/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.stats.Distribution;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CachedDistribution {
    private final Supplier<Distribution> distributionSupplier;
    @GuardedBy(value="this")
    private Distribution distribution;
    @GuardedBy(value="this")
    private long lastUpdate = System.nanoTime();

    public CachedDistribution(Supplier<Distribution> distributionSupplier) {
        this.distributionSupplier = distributionSupplier;
    }

    public synchronized Distribution getDistribution() {
        if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.lastUpdate) > 1000L) {
            this.distribution = this.distributionSupplier.get();
            this.lastUpdate = System.nanoTime();
        }
        return this.distribution;
    }

    @Managed
    public double getCount() {
        return this.getDistribution().getCount();
    }

    @Managed
    public double getTotal() {
        return this.getDistribution().getTotal();
    }

    @Managed
    public double getP01() {
        return this.getDistribution().getP01();
    }

    @Managed
    public double getP05() {
        return this.getDistribution().getP05();
    }

    @Managed
    public double getP10() {
        return this.getDistribution().getP10();
    }

    @Managed
    public double getP25() {
        return this.getDistribution().getP25();
    }

    @Managed
    public double getP50() {
        return this.getDistribution().getP50();
    }

    @Managed
    public double getP75() {
        return this.getDistribution().getP75();
    }

    @Managed
    public double getP90() {
        return this.getDistribution().getP90();
    }

    @Managed
    public double getP95() {
        return this.getDistribution().getP95();
    }

    @Managed
    public double getP99() {
        return this.getDistribution().getP99();
    }

    @Managed
    public double getMin() {
        return this.getDistribution().getMin();
    }

    @Managed
    public double getMax() {
        return this.getDistribution().getMax();
    }

    @Managed
    public Map<Double, Double> getPercentiles() {
        return this.getDistribution().getPercentiles();
    }
}

