/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trino.spi.Mergeable;
import io.trino.spi.Unstable;
import io.trino.spi.metrics.Metric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class Metrics
implements Mergeable<Metrics> {
    public static final Metrics EMPTY = new Metrics(Map.of());
    private final Map<String, Metric<?>> metrics;

    @JsonCreator
    @Unstable
    public Metrics(Map<String, Metric<?>> metrics) {
        this.metrics = Map.copyOf(Objects.requireNonNull(metrics, "metrics is null"));
    }

    @JsonValue
    public Map<String, Metric<?>> getMetrics() {
        return this.metrics;
    }

    @Override
    public Metrics mergeWith(Metrics other) {
        return Metrics.accumulator().add(this).add(other).get();
    }

    public static Accumulator accumulator() {
        return new Accumulator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metrics)) {
            return false;
        }
        Metrics that = (Metrics)o;
        return this.metrics.equals(that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.metrics);
    }

    public String toString() {
        return new StringJoiner(", ", Metrics.class.getSimpleName() + "[", "]").add(this.metrics.toString()).toString();
    }

    public static class Accumulator {
        private final Map<String, List<Metric<?>>> groupedMetrics = new HashMap();

        private Accumulator() {
        }

        public Accumulator add(Metrics metrics) {
            metrics.getMetrics().forEach((key, value) -> this.groupedMetrics.computeIfAbsent((String)key, ignored -> new ArrayList()).add(value));
            return this;
        }

        public Metrics get() {
            if (this.groupedMetrics.isEmpty()) {
                return EMPTY;
            }
            HashMap merged = new HashMap();
            this.groupedMetrics.forEach((key, values) -> merged.put((String)key, Accumulator.merge((Metric)values.get(0), values.subList(1, values.size()))));
            return new Metrics(merged);
        }

        private static Metric<?> merge(Metric<?> a, List<Metric<?>> b) {
            return a.mergeWith(b);
        }
    }
}

