/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ConnectorContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

final class SpiVersionHolder {
    static final String SPI_VERSION;

    private SpiVersionHolder() {
    }

    static {
        try {
            URL resource = ConnectorContext.class.getClassLoader().getResource("io/trino/spi/trino-spi-version.txt");
            Objects.requireNonNull(resource, "version resource not found");
            try (InputStream inputStream = resource.openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String spiVersion = reader.readLine();
                if (spiVersion == null || spiVersion.isBlank() || reader.readLine() != null) {
                    throw new IllegalStateException("Malformed version resource");
                }
                SPI_VERSION = spiVersion.strip();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

