/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableColumnsMetadata {
    private final SchemaTableName table;
    private final Optional<List<ColumnMetadata>> columns;

    public TableColumnsMetadata(SchemaTableName table, Optional<List<ColumnMetadata>> columns) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
    }

    public static TableColumnsMetadata forTable(SchemaTableName table, List<ColumnMetadata> columns) {
        return new TableColumnsMetadata(table, Optional.of(Objects.requireNonNull(columns, "columns is null")));
    }

    public static TableColumnsMetadata forRedirectedTable(SchemaTableName table) {
        return new TableColumnsMetadata(table, Optional.empty());
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public Optional<List<ColumnMetadata>> getColumns() {
        return this.columns;
    }
}

