/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.ldap;

import java.util.Arrays;
import java.util.Objects;

public class LdapQuery {
    private final String searchBase;
    private final String searchFilter;
    private final Object[] searchFilterArguments;
    private final String[] attributes;

    private LdapQuery(String searchBase, String searchFilter, Object[] searchFilterArguments, String[] attributes) {
        this.searchBase = Objects.requireNonNull(searchBase, "searchBase is null");
        this.searchFilter = Objects.requireNonNull(searchFilter, "searchFilter is null");
        this.searchFilterArguments = searchFilterArguments;
        Objects.requireNonNull(attributes, "attributes is null");
        this.attributes = Arrays.copyOf(attributes, attributes.length);
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public Object[] getSearchFilterArguments() {
        return this.searchFilterArguments;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "LdapQuery{searchBase='" + this.searchBase + "', searchFilter='" + this.searchFilter + "', searchFilterArguments=" + Arrays.toString(this.searchFilterArguments) + ", attributes=" + Arrays.toString(this.attributes) + "}";
    }

    public static class LdapQueryBuilder {
        private String searchBase;
        private String searchFilter;
        private Object[] searchFilterArguments;
        private String[] attributes = new String[0];

        public LdapQueryBuilder withSearchBase(String searchBase) {
            this.searchBase = Objects.requireNonNull(searchBase, "searchBase is null");
            return this;
        }

        public LdapQueryBuilder withSearchFilter(String searchFilter) {
            this.searchFilter = Objects.requireNonNull(searchFilter, "searchFilter is null");
            return this;
        }

        public LdapQueryBuilder withSearchFilterArguments(Object ... searchFilterArguments) {
            this.searchFilterArguments = Objects.requireNonNull(searchFilterArguments, "searchFilterArguments is null");
            return this;
        }

        public LdapQueryBuilder withAttributes(String ... attributes) {
            this.attributes = Objects.requireNonNull(attributes, "attributes is null");
            return this;
        }

        public LdapQuery build() {
            return new LdapQuery(this.searchBase, this.searchFilter, this.searchFilterArguments, this.attributes);
        }
    }
}

