/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.transport.internal;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConversation;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.HttpResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.transport.internal.ClientHTTP2StreamEndPoint;
import org.eclipse.jetty.http2.client.transport.internal.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements HTTP2Channel.Client {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiverOverHTTP2.class);

    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    protected void onInterim() {
    }

    public Content.Chunk read(boolean fillInterestIfNeeded) {
        boolean last;
        Stream stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading, fillInterestIfNeeded={} in {}", (Object)fillInterestIfNeeded, (Object)this);
        }
        if ((stream = this.getHttpChannel().getStream()) == null) {
            return Content.Chunk.from((Throwable)new EOFException("Channel has been released"));
        }
        Stream.Data data = stream.readData();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read stream data {} in {}", (Object)data, (Object)this);
        }
        if (data == null) {
            if (fillInterestIfNeeded) {
                stream.demand();
            }
            return null;
        }
        DataFrame frame = data.frame();
        boolean bl = last = frame.remaining() == 0 && frame.isEndStream();
        if (!last) {
            return Content.Chunk.asChunk((ByteBuffer)frame.getByteBuffer(), (boolean)false, (Retainable)data);
        }
        data.release();
        if (stream.isReset()) {
            EOFException failure = new EOFException("Stream has been reset");
            this.responseFailure(failure, Promise.noop());
            return Content.Chunk.from((Throwable)failure);
        }
        this.responseSuccess(this.getHttpExchange(), null);
        return Content.Chunk.EOF;
    }

    public void failAndClose(Throwable failure) {
        Stream stream = this.getHttpChannel().getStream();
        this.responseFailure(failure, Promise.from(failed -> {
            if (failed.booleanValue()) {
                stream.reset(new ResetFrame(stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
            }
        }, x -> stream.reset(new ResetFrame(stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP)));
    }

    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    void onHeaders(Stream stream, HeadersFrame frame) {
        MetaData metaData = frame.getMetaData();
        if (metaData.isResponse()) {
            this.onResponse(stream, frame);
        } else {
            this.onTrailer(frame);
        }
    }

    private void onResponse(Stream stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        MetaData.Response response = (MetaData.Response)frame.getMetaData();
        HttpResponse httpResponse = exchange.getResponse();
        httpResponse.version(response.getHttpVersion()).status(response.getStatus()).reason(response.getReason());
        this.responseBegin(exchange);
        HttpFields headers = response.getHttpFields();
        for (HttpField header : headers) {
            this.responseHeader(exchange, header);
        }
        HttpRequest httpRequest = exchange.getRequest();
        if (MetaData.isTunnel((String)httpRequest.getMethod(), (int)httpResponse.getStatus())) {
            ClientHTTP2StreamEndPoint endPoint = new ClientHTTP2StreamEndPoint((HTTP2Stream)stream);
            long idleTimeout = httpRequest.getIdleTimeout();
            if (idleTimeout > 0L) {
                endPoint.setIdleTimeout(idleTimeout);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successful HTTP2 tunnel on {} via {} in {}", new Object[]{stream, endPoint, this});
            }
            ((HTTP2Stream)stream).setAttachment((Object)endPoint);
            HttpConversation conversation = httpRequest.getConversation();
            conversation.setAttribute(EndPoint.class.getName(), (Object)endPoint);
            HttpUpgrader upgrader = (HttpUpgrader)conversation.getAttribute(HttpUpgrader.class.getName());
            if (upgrader != null) {
                this.upgrade(upgrader, httpResponse, (EndPoint)endPoint);
            }
        }
        this.responseHeaders(exchange);
    }

    private void onTrailer(HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpFields trailers = frame.getMetaData().getHttpFields();
        trailers.forEach(arg_0 -> ((HttpResponse)exchange.getResponse()).trailer(arg_0));
    }

    private void upgrade(HttpUpgrader upgrader, HttpResponse response, EndPoint endPoint) {
        try {
            upgrader.upgrade((Response)response, endPoint, Callback.from(() -> ((Callback)Callback.NOOP).succeeded(), failure -> this.responseFailure((Throwable)failure, Promise.noop())));
        }
        catch (Throwable x) {
            this.responseFailure(x, Promise.noop());
        }
    }

    Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        Response.CompleteListener listener;
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return null;
        }
        HttpRequest request = exchange.getRequest();
        MetaData.Request metaData = frame.getMetaData();
        HttpRequest pushRequest = (HttpRequest)this.getHttpDestination().getHttpClient().newRequest(metaData.getHttpURI().toString());
        BiFunction pushHandler = request.getPushHandler();
        if (pushHandler != null && (listener = (Response.CompleteListener)pushHandler.apply(request, pushRequest)) != null) {
            HttpChannelOverHTTP2 pushChannel = this.getHttpChannel().getHttpConnection().newHttpChannel();
            pushRequest.getResponseListeners().addCompleteListener(listener, true);
            HttpExchange pushExchange = new HttpExchange(this.getHttpDestination(), pushRequest);
            pushChannel.associate(pushExchange);
            pushChannel.setStream(stream);
            pushExchange.requestComplete(null);
            pushExchange.terminateRequest();
            return pushChannel.getStreamListener();
        }
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
        return null;
    }

    public Runnable onDataAvailable() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return null;
        }
        return new Invocable.ReadyTask(Invocable.InvocationType.NON_BLOCKING, () -> this.responseContentAvailable(exchange));
    }

    public Runnable onReset(ResetFrame frame, Callback callback) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            callback.succeeded();
            return null;
        }
        return new Invocable.ReadyTask(Invocable.InvocationType.NON_BLOCKING, () -> {
            int error = frame.getError();
            IOException failure = new IOException(ErrorCode.toString((int)error, (String)("reset_code_" + error)));
            callback.completeWith(exchange.getRequest().abort((Throwable)failure));
        });
    }

    public Runnable onTimeout(TimeoutException failure, Promise<Boolean> promise) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            promise.succeeded((Object)false);
            return null;
        }
        return new Invocable.ReadyTask(Invocable.InvocationType.NON_BLOCKING, () -> promise.completeWith(exchange.getRequest().abort((Throwable)failure)));
    }

    public Runnable onFailure(Throwable failure, Callback callback) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            return new FailureTask(exchange, failure, callback);
        }
        callback.succeeded();
        return null;
    }

    private static class FailureTask
    extends Invocable.Task.Abstract {
        private final HttpExchange exchange;
        private final Throwable failure;
        private final Callback callback;

        private FailureTask(HttpExchange exchange, Throwable failure, Callback callback) {
            super(Invocable.InvocationType.NON_BLOCKING);
            this.exchange = exchange;
            this.failure = failure;
            this.callback = callback;
        }

        public void run() {
            this.callback.completeWith(this.exchange.getRequest().abort(this.failure));
        }
    }
}

