/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.local;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

public class CatalogLocalFileSystemConfig {
    private static final String ROOT_PATH = "root-path";
    private File rootPath;

    public File getRootPath() {
        return this.rootPath;
    }

    @Config(value="root-path")
    @ConfigDescription(value="Root path in the local file system")
    public CatalogLocalFileSystemConfig setRootPath(File rootPath) {
        this.rootPath = rootPath;
        return this;
    }

    public static Optional<String> validateProperties(Map<String, String> mutableConfig) {
        String rootPathString = mutableConfig.get(ROOT_PATH);
        if (rootPathString == null || rootPathString.trim().isEmpty()) {
            return Optional.of(String.format("\"%s\" cannot be empty", ROOT_PATH));
        }
        if (!Files.isDirectory(Path.of(rootPathString = rootPathString.trim(), new String[0]), new LinkOption[0])) {
            return Optional.of(String.format("\"%s\" with value \"%s\" doesn't exist or is not a directory", ROOT_PATH, rootPathString));
        }
        mutableConfig.put(ROOT_PATH, rootPathString);
        return Optional.empty();
    }
}

