/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.engine.cedrusdata;

import java.util.Map;
import java.util.Set;
import org.jdbi.v3.core.Jdbi;
import ru.cedrusdata.catalog.engine.cedrusdata.AbstractCatalogCedrusDataOperationFactory;
import ru.cedrusdata.catalog.engine.cedrusdata.CatalogCedrusDataOptimizeOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationFactory;
import ru.cedrusdata.catalog.spi.computeengine.CatalogTable;
import ru.cedrusdata.catalog.spi.computeengine.result.Accumulator;
import ru.cedrusdata.catalog.spi.computeengine.result.CompositeComputeEngineResultAggregator;
import ru.cedrusdata.catalog.spi.computeengine.result.ComputeEngineResultAggregator;
import ru.cedrusdata.catalog.spi.computeengine.result.LongAccumulator;

public class CatalogCedrusDataOptimizeOperationFactory
extends AbstractCatalogCedrusDataOperationFactory {
    static final String OPTIMIZE = "optimize";
    static final String PARAM_FILE_SIZE_THRESHOLD = "file-size-threshold";
    static final long DEFAULT_FILE_SIZE_THRESHOLD = 0x6400000L;
    static final String PARAM_WHERE = "where";
    private final long fileSizeThresholdBytes;
    private final String whereClause;

    public CatalogCedrusDataOptimizeOperationFactory(Map<String, String> params, Jdbi jdbi, boolean resultReturnSupported) {
        super(jdbi, resultReturnSupported);
        CatalogComputeEngineOperationFactory.validateNoExtraParameters((String)OPTIMIZE, params, Set.of(PARAM_FILE_SIZE_THRESHOLD, PARAM_WHERE));
        this.fileSizeThresholdBytes = CatalogComputeEngineOperationFactory.parsePositiveLongParameter(params, (String)PARAM_FILE_SIZE_THRESHOLD, (long)0x6400000L);
        this.whereClause = params.get(PARAM_WHERE);
    }

    public String name() {
        return OPTIMIZE;
    }

    public CatalogComputeEngineOperation createTableOperation(CatalogTable table) {
        return new CatalogCedrusDataOptimizeOperation(this.jdbi, table, this.fileSizeThresholdBytes, this.whereClause);
    }

    @Override
    public ComputeEngineResultAggregator doCreateResultAggregator() {
        return CompositeComputeEngineResultAggregator.newBuilder().add("added-data-files", (Accumulator)new LongAccumulator()).add("deleted-data-files", (Accumulator)new LongAccumulator()).add("deleted-delete-files", (Accumulator)new LongAccumulator()).build();
    }
}

