/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.hdfs;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.trino.hdfs.authentication.ForHdfs;
import io.trino.hdfs.authentication.HadoopAuthentication;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.ImpersonatingHdfsAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.hdfs.authentication.SimpleHadoopAuthentication;
import io.trino.plugin.base.security.UserNameProvider;

public class CatalogHdfsFileSystemSimpleAuthenticationModule
implements Module {
    private final boolean impersonationEnabled;

    public CatalogHdfsFileSystemSimpleAuthenticationModule(boolean impersonationEnabled) {
        this.impersonationEnabled = impersonationEnabled;
    }

    public void configure(Binder binder) {
        if (this.impersonationEnabled) {
            binder.bind(HadoopAuthentication.class).annotatedWith(ForHdfs.class).to(SimpleHadoopAuthentication.class);
            OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(UserNameProvider.class, ForHdfs.class)).setDefault().toInstance((Object)UserNameProvider.SIMPLE_USER_NAME_PROVIDER);
            binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(HdfsAuthentication.class).to(NoHdfsAuthentication.class).in(Scopes.SINGLETON);
        }
    }
}

