/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs;

import com.google.common.base.Preconditions;
import io.trino.spi.classloader.ThreadContextClassLoader;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public final class ConfigurationUtils {
    private static final Configuration INITIAL_CONFIGURATION;

    private ConfigurationUtils() {
    }

    public static Configuration getInitialConfiguration() {
        return ConfigurationUtils.copy(INITIAL_CONFIGURATION);
    }

    public static Configuration copy(Configuration configuration) {
        Configuration copy = ConfigurationUtils.newEmptyConfiguration();
        ConfigurationUtils.copy(configuration, copy);
        return copy;
    }

    public static void copy(Configuration from, Configuration to) {
        for (Map.Entry entry : from) {
            to.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Configuration readConfiguration(List<File> resourcePaths) {
        Configuration result = ConfigurationUtils.newEmptyConfiguration();
        for (File resourcePath : resourcePaths) {
            Preconditions.checkArgument((boolean)resourcePath.exists(), (String)"File does not exist: %s", (Object)resourcePath);
            Configuration resourceProperties = ConfigurationUtils.newEmptyConfiguration();
            resourceProperties.addResource(new Path(resourcePath.getPath()));
            ConfigurationUtils.copy(resourceProperties, result);
        }
        return result;
    }

    public static Configuration newEmptyConfiguration() {
        return ConfigurationUtils.newConfiguration(false);
    }

    private static Configuration newConfiguration(boolean loadDefaults) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(ConfigurationUtils.class.getClassLoader());){
            Configuration configuration = new Configuration(loadDefaults);
            return configuration;
        }
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        INITIAL_CONFIGURATION = ConfigurationUtils.newEmptyConfiguration();
        Configuration defaultConfiguration = ConfigurationUtils.newConfiguration(true);
        ConfigurationUtils.copy(defaultConfiguration, INITIAL_CONFIGURATION);
    }
}

