/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.instrumentation.awssdk.v2_2.AwsJsonProtocolFactoryAccess;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringUtils;

class Serializer {
    Serializer() {
    }

    @Nullable
    String serialize(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof SdkPojo) {
            return Serializer.serialize((SdkPojo)target);
        }
        if (target instanceof Collection) {
            return this.serialize((Collection)target);
        }
        if (target instanceof Map) {
            return this.serialize(((Map)target).keySet());
        }
        return target.toString();
    }

    @Nullable
    private static String serialize(SdkPojo sdkPojo) {
        ProtocolMarshaller<SdkHttpFullRequest> marshaller = AwsJsonProtocolFactoryAccess.createMarshaller();
        if (marshaller == null) {
            return null;
        }
        Optional optional = ((SdkHttpFullRequest)marshaller.marshall(sdkPojo)).contentStreamProvider();
        return optional.map(csp -> {
            String string;
            block8: {
                InputStream cspIs = csp.newStream();
                try {
                    string = IoUtils.toUtf8String((InputStream)cspIs);
                    if (cspIs == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (cspIs != null) {
                            try {
                                cspIs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                cspIs.close();
            }
            return string;
        }).orElse(null);
    }

    private String serialize(Collection<?> collection) {
        String serialized = collection.stream().map(this::serialize).collect(Collectors.joining(","));
        return StringUtils.isEmpty((CharSequence)serialized) ? null : "[" + serialized + "]";
    }
}

