/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.encoding.JsonQueryDataDecoder;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class QueryDataDecoders {
    private static final List<QueryDataDecoder.Factory> decoders = ImmutableList.of(new JsonQueryDataDecoder.Factory(), new JsonQueryDataDecoder.ZstdFactory(), new JsonQueryDataDecoder.Lz4Factory());
    private static final Map<String, QueryDataDecoder.Factory> encodingMap = QueryDataDecoders.factoriesMap();

    private QueryDataDecoders() {
    }

    public static QueryDataDecoder.Factory get(String encoding) {
        if (!encodingMap.containsKey(encoding)) {
            throw new IllegalArgumentException("Unknown encoding: " + encoding);
        }
        QueryDataDecoder.Factory factory2 = encodingMap.get(encoding);
        Verify.verify(factory2.encoding().equals(encoding), "Factory has wrong encoding, expected %s, got %s", (Object)encoding, (Object)factory2.encoding());
        return factory2;
    }

    public static boolean exists(String encoding) {
        return encodingMap.containsKey(encoding);
    }

    public static Set<String> getSupportedEncodings() {
        return encodingMap.keySet();
    }

    private static Map<String, QueryDataDecoder.Factory> factoriesMap() {
        return decoders.stream().collect(ImmutableMap.toImmutableMap(QueryDataDecoder.Factory::encoding, Function.identity()));
    }
}

