/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.Column;
import io.trino.jdbc.$internal.client.FixJsonDataUtils;
import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.DataAttributes;
import io.trino.jdbc.$internal.client.spooling.encoding.Lz4QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.encoding.ZstdQueryDataDecoder;
import io.trino.jdbc.$internal.jackson.core.type.TypeReference;
import io.trino.jdbc.$internal.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;

public class JsonQueryDataDecoder
implements QueryDataDecoder {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<List<List<Object>>> TYPE = new TypeReference<List<List<Object>>>(){};
    private final List<Column> columns;

    public JsonQueryDataDecoder(List<Column> columns) {
        this.columns = Objects.requireNonNull(columns, "columns is null");
    }

    @Override
    public Iterable<List<Object>> decode(InputStream stream, DataAttributes attributes) {
        try {
            return FixJsonDataUtils.fixData(this.columns, (Iterable<List<Object>>)OBJECT_MAPPER.readValue(stream, TYPE));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String encoding() {
        return "json";
    }

    public static class JsonSchema {
        private final int[] offsets;
        private final int step;

        @.JsonCreator
        public JsonSchema(int[] offsets, int step) {
            this.offsets = offsets;
            this.step = step;
        }

        @.JsonProperty(value="offsets")
        public int[] getOffsets() {
            return this.offsets;
        }

        @.JsonProperty(value="step")
        public int getStep() {
            return this.step;
        }
    }

    public static class Lz4Factory
    extends Factory {
        @Override
        public QueryDataDecoder create(List<Column> columns, DataAttributes queryAttributes) {
            return new Lz4QueryDataDecoder(super.create(columns, queryAttributes));
        }

        @Override
        public String encoding() {
            return super.encoding() + "+lz4";
        }
    }

    public static class ZstdFactory
    extends Factory {
        @Override
        public QueryDataDecoder create(List<Column> columns, DataAttributes queryAttributes) {
            return new ZstdQueryDataDecoder(super.create(columns, queryAttributes));
        }

        @Override
        public String encoding() {
            return super.encoding() + "+zstd";
        }
    }

    public static class Factory
    implements QueryDataDecoder.Factory {
        @Override
        public QueryDataDecoder create(List<Column> columns, DataAttributes queryAttributes) {
            return new JsonQueryDataDecoder(columns);
        }

        @Override
        public String encoding() {
            return "json";
        }
    }
}

