/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.vm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Random;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.layouters.CurrentLayouter;
import org.openjdk.jol.util.MathUtil;
import org.openjdk.jol.vm.Experiments;
import org.openjdk.jol.vm.VMOptions;
import org.openjdk.jol.vm.VirtualMachine;
import org.openjdk.jol.vm.sa.UniverseData;
import sun.misc.Unsafe;

class HotspotUnsafe
implements VirtualMachine {
    private static final String MAGIC_FIELD_OFFSET_OPTION = "jol.magicFieldOffset";
    private static final boolean MAGIC_FIELD_OFFSET = Boolean.parseBoolean(System.getProperty("jol.magicFieldOffset", "false"));
    private final Unsafe U;
    private final Instrumentation instrumentation;
    private final boolean isAccurate;
    private final int addressSize;
    private final int objectAlignment;
    private final int oopSize;
    private final boolean compressedOopsEnabled;
    private final long narrowOopBase;
    private final int narrowOopShift;
    private final boolean compressedKlassOopsEnabled;
    private final long narrowKlassBase;
    private final int narrowKlassShift;
    private final int arrayHeaderSize;
    private final int objectHeaderSize;
    private final long arrayObjectBase;
    private final Sizes sizes;
    private final boolean lilliputVM;
    private volatile boolean mfoInitialized;
    private Object mfoUnsafe;
    private Method mfoMethod;
    private final ThreadLocal<Object[]> BUFFERS = ThreadLocal.withInitial(() -> new Object[1]);

    HotspotUnsafe(Unsafe u, Instrumentation inst, UniverseData saDetails) {
        this.U = u;
        this.instrumentation = inst;
        this.isAccurate = true;
        this.arrayObjectBase = this.U.arrayBaseOffset(Object[].class);
        this.addressSize = saDetails.getAddressSize();
        this.oopSize = saDetails.getOopSize();
        this.objectHeaderSize = this.guessHeaderSize();
        this.arrayHeaderSize = this.objectHeaderSize + 4;
        this.compressedOopsEnabled = saDetails.isCompressedOopsEnabled();
        this.compressedKlassOopsEnabled = saDetails.isCompressedKlassPtrsEnabled();
        this.objectAlignment = saDetails.getObjectAlignment();
        this.narrowOopShift = saDetails.getNarrowOopShift();
        this.narrowKlassShift = saDetails.getNarrowKlassShift();
        this.narrowOopBase = saDetails.getNarrowOopBase();
        this.narrowKlassBase = saDetails.getNarrowKlassBase();
        this.sizes = new Sizes(this);
        this.lilliputVM = this.guessLilliput(this.addressSize);
    }

    HotspotUnsafe(Unsafe u, Instrumentation inst) {
        this.U = u;
        this.instrumentation = inst;
        this.isAccurate = false;
        this.arrayObjectBase = this.U.arrayBaseOffset(Object[].class);
        this.addressSize = this.U.addressSize();
        this.oopSize = this.guessOopSize();
        this.objectHeaderSize = this.guessHeaderSize();
        this.arrayHeaderSize = this.objectHeaderSize + 4;
        Boolean coops = VMOptions.pollCompressedOops();
        this.compressedOopsEnabled = coops != null ? coops : this.addressSize != this.oopSize;
        Boolean ccptrs = VMOptions.pollCompressedClassPointers();
        this.compressedKlassOopsEnabled = ccptrs != null ? ccptrs : this.addressSize != this.oopSize;
        Integer align = VMOptions.pollObjectAlignment();
        this.objectAlignment = align != null ? align.intValue() : this.guessAlignment();
        this.narrowOopShift = this.compressedOopsEnabled ? MathUtil.log2p(this.objectAlignment) : 0;
        this.narrowKlassShift = this.compressedKlassOopsEnabled ? MathUtil.log2p(this.objectAlignment) : 0;
        this.narrowOopBase = this.guessNarrowOopBase();
        this.narrowKlassBase = 0L;
        this.sizes = new Sizes(this);
        this.lilliputVM = this.guessLilliput(this.addressSize);
    }

    private boolean guessLilliput(int addressSize) {
        for (int t = 0; t < 100; ++t) {
            Experiments.MyObject0 o1 = new Experiments.MyObject0();
            Experiments.MyObject1 o2 = new Experiments.MyObject1();
            if (addressSize == 4) {
                if (this.getInt(o1, 0L) == this.getInt(o2, 0L)) {
                    return false;
                }
            } else if (addressSize == 8) {
                if (this.getLong(o1, 0L) == this.getLong(o2, 0L)) {
                    return false;
                }
            } else {
                throw new IllegalArgumentException("Unknown address size: " + addressSize);
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    private long guessNarrowOopBase() {
        return this.addressOf(null);
    }

    private int guessOopSize() {
        int oopSize;
        try {
            long off1 = this.U.objectFieldOffset(Experiments.CompressedOopsClass.class.getField("obj1"));
            long off2 = this.U.objectFieldOffset(Experiments.CompressedOopsClass.class.getField("obj2"));
            oopSize = (int)Math.abs(off2 - off1);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Infrastructure failure", e);
        }
        return oopSize;
    }

    private int guessHeaderSize() {
        try {
            long off1 = this.U.objectFieldOffset(Experiments.HeaderClass.class.getField("b1"));
            return (int)off1;
        }
        catch (NoSuchFieldException e) {
            return 0;
        }
    }

    @Override
    public long sizeOf(Object o) {
        if (this.instrumentation != null) {
            return MathUtil.align(this.instrumentation.getObjectSize(o), this.objectAlignment);
        }
        return new CurrentLayouter().layout(ClassData.parseInstance(o)).instanceSize();
    }

    @Override
    public long sizeOfField(String klassName) {
        return this.sizes.get(klassName);
    }

    @Override
    public int objectAlignment() {
        return this.objectAlignment;
    }

    @Override
    public int arrayHeaderSize() {
        return this.arrayHeaderSize;
    }

    @Override
    public int objectHeaderSize() {
        return this.objectHeaderSize;
    }

    private int getMinDiff(Class<?> klass) {
        try {
            int off1 = (int)this.U.objectFieldOffset(klass.getDeclaredField("f1"));
            int off2 = (int)this.U.objectFieldOffset(klass.getDeclaredField("f2"));
            int off3 = (int)this.U.objectFieldOffset(klass.getDeclaredField("f3"));
            int off4 = (int)this.U.objectFieldOffset(klass.getDeclaredField("f4"));
            return MathUtil.minDiff(off1, off2, off3, off4);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Infrastructure failure, klass = " + klass, e);
        }
    }

    @Override
    public int addressSize() {
        return this.addressSize;
    }

    @Override
    public int classPointerSize() {
        if (this.lilliputVM) {
            return 0;
        }
        switch (this.addressSize) {
            case 4: {
                return 4;
            }
            case 8: {
                return this.compressedKlassOopsEnabled ? 4 : 8;
            }
        }
        throw new IllegalStateException("Unknown address size:" + this.addressSize);
    }

    @Override
    public String details() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("# VM mode: " + this.addressSize * 8 + " bits");
        if (this.lilliputVM) {
            out.println("# Lilliput VM detected (experimental)");
        }
        out.print("# Compressed references (oops): ");
        if (this.compressedOopsEnabled) {
            out.print(this.narrowOopShift + "-bit shift");
            if (this.narrowOopBase != 0L) {
                out.print(" and " + this.formatAddressAsHexByAddressSize(this.narrowOopBase) + " base");
            }
        } else if (this.addressSize == 4) {
            out.print("not needed");
        } else {
            out.print("disabled");
        }
        out.println();
        out.print("# Compressed class pointers: ");
        if (this.compressedKlassOopsEnabled) {
            out.print(this.narrowKlassShift + "-bit shift");
            if (this.narrowKlassBase != 0L) {
                out.print(" and " + this.formatAddressAsHexByAddressSize(this.narrowKlassBase) + " base");
            }
        } else if (this.addressSize == 4) {
            out.print("not needed");
        } else {
            out.print("disabled");
        }
        out.println();
        if (this.addressSize != 4 && !this.isAccurate && (this.compressedOopsEnabled || this.compressedKlassOopsEnabled)) {
            out.println("# WARNING | Compressed references base/shifts are guessed by the experiment!");
            out.println("# WARNING | Therefore, computed addresses are just guesses, and ARE NOT RELIABLE.");
            out.println("# WARNING | Make sure to attach Serviceability Agent to get the reliable addresses.");
        }
        out.println("# Object alignment: " + this.objectAlignment + " bytes");
        out.printf("# %-20s %4s, %4s, %4s, %4s, %4s, %4s, %4s, %4s, %4s%n", "", "ref", "bool", "byte", "char", "shrt", "int", "flt", "lng", "dbl");
        out.printf("# %-20s %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d%n", "Field sizes:", this.oopSize, this.sizes.booleanSize, this.sizes.byteSize, this.sizes.charSize, this.sizes.shortSize, this.sizes.intSize, this.sizes.floatSize, this.sizes.longSize, this.sizes.doubleSize);
        out.printf("# %-20s %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d%n", "Array element sizes:", this.U.arrayIndexScale(Object[].class), this.U.arrayIndexScale(boolean[].class), this.U.arrayIndexScale(byte[].class), this.U.arrayIndexScale(char[].class), this.U.arrayIndexScale(short[].class), this.U.arrayIndexScale(int[].class), this.U.arrayIndexScale(float[].class), this.U.arrayIndexScale(long[].class), this.U.arrayIndexScale(double[].class));
        out.printf("# %-20s %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d, %4d%n", "Array base offsets:", this.U.arrayBaseOffset(Object[].class), this.U.arrayBaseOffset(boolean[].class), this.U.arrayBaseOffset(byte[].class), this.U.arrayBaseOffset(char[].class), this.U.arrayBaseOffset(short[].class), this.U.arrayBaseOffset(int[].class), this.U.arrayBaseOffset(float[].class), this.U.arrayBaseOffset(long[].class), this.U.arrayBaseOffset(double[].class));
        out.close();
        return sw.toString();
    }

    private static Object instantiateType(int type) {
        switch (type) {
            case 0: {
                return new Experiments.MyObject1();
            }
            case 1: {
                return new Experiments.MyObject2();
            }
            case 2: {
                return new Experiments.MyObject3();
            }
            case 3: {
                return new Experiments.MyObject4();
            }
            case 4: {
                return new Experiments.MyObject5();
            }
        }
        throw new IllegalStateException();
    }

    private int guessAlignment() {
        int COUNT = 100000;
        Random r = new Random();
        long min = -1L;
        for (int c = 0; c < 100000; ++c) {
            Object o1 = HotspotUnsafe.instantiateType(r.nextInt(5));
            Object o2 = HotspotUnsafe.instantiateType(r.nextInt(5));
            long diff = Math.abs(this.addressOf(o1) - this.addressOf(o2));
            min = min == -1L ? diff : MathUtil.gcd(min, diff);
        }
        return (int)min;
    }

    @Override
    public long addressOf(Object o) {
        long objectAddress;
        Object[] array = this.BUFFERS.get();
        array[0] = o;
        switch (this.oopSize) {
            case 4: {
                objectAddress = (long)this.U.getInt(array, this.arrayObjectBase) & 0xFFFFFFFFL;
                break;
            }
            case 8: {
                objectAddress = this.U.getLong(array, this.arrayObjectBase);
                break;
            }
            default: {
                throw new Error("unsupported address size: " + this.oopSize);
            }
        }
        array[0] = null;
        return this.toNativeAddress(objectAddress);
    }

    @Override
    public int arrayBaseOffset(String arrayComponentKlass) {
        if (arrayComponentKlass.equals("byte")) {
            return this.U.arrayBaseOffset(byte[].class);
        }
        if (arrayComponentKlass.equals("boolean")) {
            return this.U.arrayBaseOffset(boolean[].class);
        }
        if (arrayComponentKlass.equals("short")) {
            return this.U.arrayBaseOffset(short[].class);
        }
        if (arrayComponentKlass.equals("char")) {
            return this.U.arrayBaseOffset(char[].class);
        }
        if (arrayComponentKlass.equals("int")) {
            return this.U.arrayBaseOffset(int[].class);
        }
        if (arrayComponentKlass.equals("float")) {
            return this.U.arrayBaseOffset(float[].class);
        }
        if (arrayComponentKlass.equals("long")) {
            return this.U.arrayBaseOffset(long[].class);
        }
        if (arrayComponentKlass.equals("double")) {
            return this.U.arrayBaseOffset(double[].class);
        }
        return this.U.arrayBaseOffset(Object[].class);
    }

    @Override
    public int arrayIndexScale(String arrayComponentKlass) {
        if (arrayComponentKlass.equals("byte")) {
            return this.U.arrayIndexScale(byte[].class);
        }
        if (arrayComponentKlass.equals("boolean")) {
            return this.U.arrayIndexScale(boolean[].class);
        }
        if (arrayComponentKlass.equals("short")) {
            return this.U.arrayIndexScale(short[].class);
        }
        if (arrayComponentKlass.equals("char")) {
            return this.U.arrayIndexScale(char[].class);
        }
        if (arrayComponentKlass.equals("int")) {
            return this.U.arrayIndexScale(int[].class);
        }
        if (arrayComponentKlass.equals("float")) {
            return this.U.arrayIndexScale(float[].class);
        }
        if (arrayComponentKlass.equals("long")) {
            return this.U.arrayIndexScale(long[].class);
        }
        if (arrayComponentKlass.equals("double")) {
            return this.U.arrayIndexScale(double[].class);
        }
        return this.U.arrayIndexScale(Object[].class);
    }

    @Override
    public boolean getBoolean(Object obj, long offset) {
        return this.U.getBoolean(obj, offset);
    }

    @Override
    public byte getByte(Object obj, long offset) {
        return this.U.getByte(obj, offset);
    }

    @Override
    public short getShort(Object obj, long offset) {
        return this.U.getShort(obj, offset);
    }

    @Override
    public char getChar(Object obj, long offset) {
        return this.U.getChar(obj, offset);
    }

    @Override
    public int getInt(Object obj, long offset) {
        return this.U.getInt(obj, offset);
    }

    @Override
    public float getFloat(Object obj, long offset) {
        return this.U.getFloat(obj, offset);
    }

    @Override
    public long getLong(Object obj, long offset) {
        return this.U.getLong(obj, offset);
    }

    @Override
    public double getDouble(Object obj, long offset) {
        return this.U.getDouble(obj, offset);
    }

    @Override
    public Object getObject(Object obj, long offset) {
        return this.U.getObject(obj, offset);
    }

    @Override
    public long fieldOffset(Field field) {
        try {
            if (Modifier.isStatic(field.getModifiers())) {
                return this.U.staticFieldOffset(field);
            }
            return this.U.objectFieldOffset(field);
        }
        catch (UnsupportedOperationException uoe) {
            if (MAGIC_FIELD_OFFSET) {
                return this.magicFieldOffset(field, uoe);
            }
            throw new RuntimeException("Cannot get the field offset, try with -Djol.magicFieldOffset=true", uoe);
        }
    }

    private long magicFieldOffset(Field field, RuntimeException original) {
        if (!this.mfoInitialized) {
            long magicOffset = -1L;
            try {
                Method acFalse = HotspotUnsafe.class.getDeclaredMethod("magicFieldOffset", Field.class, RuntimeException.class);
                Method acTrue = HotspotUnsafe.class.getDeclaredMethod("magicFieldOffset", Field.class, RuntimeException.class);
                acFalse.setAccessible(false);
                acTrue.setAccessible(true);
                Method acTest = HotspotUnsafe.class.getDeclaredMethod("magicFieldOffset", Field.class, RuntimeException.class);
                long sizeOf = this.sizeOf(acFalse);
                for (long off = sizeOf - 1L; off >= 0L; --off) {
                    boolean vFalse = this.U.getBoolean(acFalse, off);
                    boolean vTrue = this.U.getBoolean(acTrue, off);
                    if (vFalse || !vTrue) continue;
                    boolean good = true;
                    for (int t = 0; t < 3; ++t) {
                        boolean test = (t & 1) == 0;
                        acTest.setAccessible(test);
                        if (this.U.getBoolean(acTest, off) == test) continue;
                        good = false;
                        break;
                    }
                    if (!good) continue;
                    magicOffset = off;
                    break;
                }
            }
            catch (Exception acFalse) {
                // empty catch block
            }
            if (magicOffset != -1L) {
                try {
                    Class<?> cl = Class.forName("jdk.internal.misc.Unsafe");
                    Field fu = cl.getDeclaredField("theUnsafe");
                    this.mfoUnsafe = this.U.getObject(this.U.staticFieldBase(fu), this.U.staticFieldOffset(fu));
                    Method mfo = this.mfoUnsafe.getClass().getMethod("objectFieldOffset", Field.class);
                    Method canAccess = Method.class.getMethod("canAccess", Object.class);
                    if (!((Boolean)canAccess.invoke((Object)mfo, this.mfoUnsafe)).booleanValue()) {
                        long slotOffset = magicOffset >> 2 << 2;
                        int old = this.U.getInt(mfo, slotOffset);
                        this.U.putBoolean(mfo, magicOffset, true);
                        if (!((Boolean)canAccess.invoke((Object)mfo, this.mfoUnsafe)).booleanValue()) {
                            this.U.putInt(mfo, slotOffset, old);
                            throw new IllegalStateException("Hard failure: magic offset calculation must be wrong");
                        }
                    }
                    this.mfoMethod = mfo;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mfoInitialized = true;
        }
        if (this.mfoMethod == null || this.mfoUnsafe == null) {
            throw original;
        }
        try {
            return (Long)this.mfoMethod.invoke(this.mfoUnsafe, field);
        }
        catch (Exception e) {
            IllegalStateException ex = new IllegalStateException("Unable to get the offset for " + field);
            ex.addSuppressed(original);
            ex.addSuppressed(e);
            throw ex;
        }
    }

    private long toNativeAddress(long address) {
        if (this.compressedOopsEnabled) {
            return this.narrowOopBase + (address << this.narrowOopShift);
        }
        return address;
    }

    private long toJvmAddress(long address) {
        if (this.compressedOopsEnabled) {
            return (address >> this.narrowOopShift) - this.narrowOopBase;
        }
        return address;
    }

    private long toNativeOopAddress(long address) {
        if (this.compressedOopsEnabled) {
            return this.narrowOopBase + (address << this.narrowOopShift);
        }
        return address;
    }

    private long toJvmOopAddress(long address) {
        if (this.compressedOopsEnabled) {
            return (address >> this.narrowOopShift) - this.narrowOopBase;
        }
        return address;
    }

    private long toNativeKlassAddress(long address) {
        if (this.compressedKlassOopsEnabled) {
            return this.narrowKlassBase + (address << this.narrowKlassShift);
        }
        return address;
    }

    private long toJvmKlassAddress(long address) {
        if (this.compressedKlassOopsEnabled) {
            return (address >> this.narrowKlassShift) - this.narrowKlassBase;
        }
        return address;
    }

    private String formatAddressAsHexByAddressSize(long address) {
        return "0x" + String.format("%s", Long.toHexString(address).toUpperCase()).replace(' ', '0');
    }

    private static class Sizes {
        private final int booleanSize;
        private final int byteSize;
        private final int shortSize;
        private final int charSize;
        private final int floatSize;
        private final int intSize;
        private final int longSize;
        private final int doubleSize;
        private final int oopSize;

        Sizes(HotspotUnsafe vm) {
            this.booleanSize = vm.getMinDiff(Experiments.MyBooleans4.class);
            this.byteSize = vm.getMinDiff(Experiments.MyBytes4.class);
            this.shortSize = vm.getMinDiff(Experiments.MyShorts4.class);
            this.charSize = vm.getMinDiff(Experiments.MyChars4.class);
            this.floatSize = vm.getMinDiff(Experiments.MyFloats4.class);
            this.intSize = vm.getMinDiff(Experiments.MyInts4.class);
            this.longSize = vm.getMinDiff(Experiments.MyLongs4.class);
            this.doubleSize = vm.getMinDiff(Experiments.MyDoubles4.class);
            this.oopSize = vm.oopSize;
        }

        public long get(String klassName) {
            if (klassName.equals("byte")) {
                return this.byteSize;
            }
            if (klassName.equals("boolean")) {
                return this.booleanSize;
            }
            if (klassName.equals("short")) {
                return this.shortSize;
            }
            if (klassName.equals("char")) {
                return this.charSize;
            }
            if (klassName.equals("int")) {
                return this.intSize;
            }
            if (klassName.equals("float")) {
                return this.floatSize;
            }
            if (klassName.equals("long")) {
                return this.longSize;
            }
            if (klassName.equals("double")) {
                return this.doubleSize;
            }
            return this.oopSize;
        }
    }
}

