/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.common.http.authenticator;

import com.sun.net.httpserver.BasicAuthenticator;
import io.prometheus.jmx.common.http.authenticator.Credentials;
import io.prometheus.jmx.common.http.authenticator.CredentialsCache;
import io.prometheus.jmx.common.util.Precondition;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;

public class MessageDigestAuthenticator
extends BasicAuthenticator {
    private static final int MAXIMUM_VALID_CACHE_SIZE_BYTES = 1000000;
    private static final int MAXIMUM_INVALID_CACHE_SIZE_BYTES = 10000000;
    private final String username;
    private final String passwordHash;
    private final String algorithm;
    private final String salt;
    private final CredentialsCache validCredentialsCache;
    private final CredentialsCache invalidCredentialsCache;

    public MessageDigestAuthenticator(String realm, String username, String passwordHash, String algorithm, String salt) throws GeneralSecurityException {
        super(realm);
        Precondition.notNullOrEmpty(username);
        Precondition.notNullOrEmpty(passwordHash);
        Precondition.notNullOrEmpty(algorithm);
        Precondition.notNullOrEmpty(salt);
        MessageDigest.getInstance(algorithm);
        this.username = username;
        this.passwordHash = passwordHash.toLowerCase().replace(":", "");
        this.algorithm = algorithm;
        this.salt = salt;
        this.validCredentialsCache = new CredentialsCache(1000000);
        this.invalidCredentialsCache = new CredentialsCache(10000000);
    }

    @Override
    public boolean checkCredentials(String username, String password) {
        boolean isValid;
        if (username == null || password == null) {
            return false;
        }
        Credentials credentials = new Credentials(username, password);
        if (this.validCredentialsCache.contains(credentials)) {
            return true;
        }
        if (this.invalidCredentialsCache.contains(credentials)) {
            return false;
        }
        boolean bl = isValid = this.username.equals(username) && this.passwordHash.equals(MessageDigestAuthenticator.generatePasswordHash(this.algorithm, this.salt, password));
        if (isValid) {
            this.validCredentialsCache.add(credentials);
        } else {
            this.invalidCredentialsCache.add(credentials);
        }
        return isValid;
    }

    private static String generatePasswordHash(String algorithm, String salt, String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hash = digest.digest((salt + ":" + password).getBytes(StandardCharsets.UTF_8));
            BigInteger number = new BigInteger(1, hash);
            return number.toString(16).toLowerCase();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

