/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.google.inject.Inject;
import io.airlift.jaxrs.AbstractJacksonMapper;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;

@Provider
@Consumes(value={"application/x-jackson-smile"})
@Produces(value={"application/x-jackson-smile; qs=0.1"})
public class SmileMapper
extends AbstractJacksonMapper {
    @Inject
    public SmileMapper(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    protected JsonFactory getReaderJsonFactory() {
        return new SmileFactory();
    }

    @Override
    protected void write(Object value, Optional<JavaType> rootType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        SmileGenerator jsonGenerator = new SmileFactory().createGenerator(outputStream);
        jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        rootType.map(arg_0 -> ((ObjectMapper)this.objectMapper).writerFor(arg_0)).orElseGet(() -> ((ObjectMapper)this.objectMapper).writer()).writeValue((JsonGenerator)jsonGenerator, value);
    }
}

