/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.transport.internal;

import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConnection;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.HttpResponse;
import org.eclipse.jetty.client.transport.ResponseListeners;
import org.eclipse.jetty.client.transport.SendFailure;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.transport.internal.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Sweeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionOverHTTP2
extends HttpConnection
implements Sweeper.Sweepable,
ConnectionPool.MaxMultiplexable,
ConnectionPool.MaxUsable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnectionOverHTTP2.class);
    private final AutoLock lock = new AutoLock();
    private final Set<HttpChannelOverHTTP2> activeChannels = new HashSet<HttpChannelOverHTTP2>();
    private final Queue<HttpChannelOverHTTP2> idleChannels = new ArrayDeque<HttpChannelOverHTTP2>();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Session session;
    private final HTTP2Connection connection;
    private boolean closed;
    private boolean recycleHttpChannels = true;

    public HttpConnectionOverHTTP2(Destination destination, Session session, HTTP2Connection connection) {
        super((HttpDestination)destination);
        this.session = session;
        this.connection = connection;
    }

    public Session getSession() {
        return this.session;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.session.getLocalSocketAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.session.getRemoteSocketAddress();
    }

    public EndPoint.SslSessionData getSslSessionData() {
        return this.connection.getEndPoint().getSslSessionData();
    }

    public boolean isRecycleHttpChannels() {
        return this.recycleHttpChannels;
    }

    public void setRecycleHttpChannels(boolean recycleHttpChannels) {
        this.recycleHttpChannels = recycleHttpChannels;
    }

    public int getMaxMultiplex() {
        return ((HTTP2Session)this.session).getMaxLocalStreams();
    }

    public int getMaxUsage() {
        return ((HTTP2Session)this.session).getMaxTotalLocalStreams();
    }

    void setMaxUsage(int maxUsage) {
        ((HTTP2Session)this.session).setMaxTotalLocalStreams(maxUsage);
    }

    protected Iterator<HttpChannel> getHttpChannels() {
        Set<HttpChannelOverHTTP2> channels;
        try (AutoLock ignored = this.lock.lock();){
            channels = Set.copyOf(this.activeChannels);
        }
        return channels.iterator();
    }

    public SendFailure send(HttpExchange exchange) {
        HttpChannelOverHTTP2 channel;
        HttpRequest request = exchange.getRequest();
        request.version(HttpVersion.HTTP_2);
        this.normalizeRequest(request);
        try (AutoLock ignored = this.lock.lock();){
            if (this.closed) {
                SendFailure sendFailure = new SendFailure((Throwable)new ClosedChannelException(), true);
                return sendFailure;
            }
            channel = this.acquireHttpChannel();
        }
        SendFailure result = this.send(channel, exchange);
        if (result != null) {
            try (AutoLock ignored = this.lock.lock();){
                this.activeChannels.remove((Object)channel);
            }
            channel.destroy();
        }
        return result;
    }

    public void upgrade(Map<String, Object> context) {
        HttpResponse response = (HttpResponse)context.get(HttpResponse.class.getName());
        HttpRequest request = (HttpRequest)response.getRequest();
        HttpChannelOverHTTP2 http2Channel = this.acquireHttpChannel();
        HttpExchange exchange = (HttpExchange)request.getConversation().getExchanges().peekLast();
        HttpExchange newExchange = new HttpExchange(exchange.getHttpDestination(), request, new ResponseListeners());
        http2Channel.associate(newExchange);
        MetaData.Request metaData = new MetaData.Request(request.getMethod(), (HttpURI)HttpURI.from((URI)request.getURI()), HttpVersion.HTTP_2, request.getHeaders());
        HeadersFrame frame = new HeadersFrame((MetaData)metaData, null, true);
        Stream stream = ((HTTP2Session)this.session).newUpgradeStream(frame, http2Channel.getStreamListener(), failure -> {
            newExchange.requestComplete(failure);
            newExchange.terminateRequest();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upgrade failed for {}", (Object)this);
            }
        });
        if (stream != null) {
            http2Channel.setStream(stream);
            newExchange.requestComplete(null);
            newExchange.terminateRequest();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upgrade succeeded for {}", (Object)this);
            }
        }
    }

    protected void normalizeRequest(HttpRequest request) {
        super.normalizeRequest(request);
        HttpUpgrader.Factory upgraderFactory = (HttpUpgrader.Factory)request.getAttributes().get(HttpUpgrader.Factory.class.getName());
        if (upgraderFactory != null) {
            HttpUpgrader upgrader = upgraderFactory.newHttpUpgrader(HttpVersion.HTTP_2);
            request.getConversation().setAttribute(HttpUpgrader.class.getName(), (Object)upgrader);
            upgrader.prepare((Request)request);
        }
    }

    protected HttpChannelOverHTTP2 acquireHttpChannel() {
        try (AutoLock ignored = this.lock.lock();){
            HttpChannelOverHTTP2 channel = this.idleChannels.poll();
            if (channel == null) {
                channel = this.newHttpChannel();
            }
            this.activeChannels.add(channel);
            channel.acquire();
            HttpChannelOverHTTP2 httpChannelOverHTTP2 = channel;
            return httpChannelOverHTTP2;
        }
    }

    protected HttpChannelOverHTTP2 newHttpChannel() {
        return new HttpChannelOverHTTP2(this, this.getSession());
    }

    protected void release(HttpChannelOverHTTP2 channel) {
        boolean destroy;
        boolean removed;
        try (AutoLock ignored = this.lock.lock();){
            removed = this.activeChannels.remove((Object)channel);
            boolean bl = destroy = this.closed || !removed || channel.isFailed();
            if (this.isRecycleHttpChannels() && !destroy) {
                this.idleChannels.offer(channel);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("released={} destroy={} {}", new Object[]{removed, destroy, channel});
        }
        if (destroy) {
            channel.destroy();
        }
        this.getHttpDestination().release((Connection)this);
    }

    void remove() {
        this.getHttpDestination().remove((Connection)this);
    }

    void onFailure(Throwable failure, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failure {}", (Object)this, (Object)failure);
        }
        try (AutoLock ignored = this.lock.lock();){
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.destroy();
        callback.succeeded();
    }

    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Close {}", (Object)this);
        }
        try (AutoLock ignored = this.lock.lock();){
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.session.close(ErrorCode.NO_ERROR.code, "close", Callback.from(() -> {
            this.remove();
            this.destroy();
        }));
    }

    public boolean isClosed() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.closed;
            return bl;
        }
    }

    public boolean sweep() {
        if (!this.isClosed()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    void offerTask(Runnable task, boolean dispatch) {
        if (task != null) {
            this.connection.offerTask(task, dispatch);
        }
    }

    public String toString() {
        String closeState;
        try (AutoLock l = this.lock.tryLock();){
            boolean held = l.isHeldByCurrentThread();
            closeState = held ? Boolean.toString(this.closed) : "undefined";
        }
        return String.format("%s(closed=%s)[%s]", super.toString(), closeState, this.session);
    }
}

