/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;

public class MemoryFileSystemCacheConfig {
    @VisibleForTesting
    static final DataSize DEFAULT_CACHE_SIZE = DataSize.succinctBytes((long)Math.min(Math.floorDiv(Runtime.getRuntime().maxMemory(), 20L), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes()));
    private Duration ttl = new Duration(1.0, TimeUnit.HOURS);
    private DataSize maxSize = DEFAULT_CACHE_SIZE;
    private DataSize maxContentLength = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);

    @NotNull
    public Duration getCacheTtl() {
        return this.ttl;
    }

    @Config(value="fs.memory-cache.ttl")
    @ConfigDescription(value="Duration to keep files in the cache prior to eviction")
    public MemoryFileSystemCacheConfig setCacheTtl(Duration ttl) {
        this.ttl = ttl;
        return this;
    }

    @NotNull
    public DataSize getMaxSize() {
        return this.maxSize;
    }

    @Config(value="fs.memory-cache.max-size")
    @ConfigDescription(value="Maximum total size of the cache")
    public MemoryFileSystemCacheConfig setMaxSize(DataSize maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @NotNull
    @MaxDataSize(value="15MB")
    public @NotNull @MaxDataSize(value="15MB") DataSize getMaxContentLength() {
        return this.maxContentLength;
    }

    @Config(value="fs.memory-cache.max-content-length")
    @ConfigDescription(value="Maximum size of file that can be cached")
    public MemoryFileSystemCacheConfig setMaxContentLength(DataSize maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }
}

