/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.filesystem.Location;
import io.trino.filesystem.s3.S3Location;
import io.trino.filesystem.s3.S3SecurityMapping;
import io.trino.filesystem.s3.S3SecurityMappingConfig;
import io.trino.filesystem.s3.S3SecurityMappingResult;
import io.trino.filesystem.s3.S3SecurityMappings;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

final class S3SecurityMappingProvider {
    private final Supplier<S3SecurityMappings> mappingsProvider;
    private final Optional<String> roleCredentialName;
    private final Optional<String> kmsKeyIdCredentialName;
    private final Optional<String> colonReplacement;

    @Inject
    public S3SecurityMappingProvider(S3SecurityMappingConfig config, Supplier<S3SecurityMappings> mappingsProvider) {
        this(S3SecurityMappingProvider.mappingsProvider(mappingsProvider, config.getRefreshPeriod()), config.getRoleCredentialName(), config.getKmsKeyIdCredentialName(), config.getColonReplacement());
    }

    public S3SecurityMappingProvider(Supplier<S3SecurityMappings> mappingsProvider, Optional<String> roleCredentialName, Optional<String> kmsKeyIdCredentialName, Optional<String> colonReplacement) {
        this.mappingsProvider = Objects.requireNonNull(mappingsProvider, "mappingsProvider is null");
        this.roleCredentialName = Objects.requireNonNull(roleCredentialName, "roleCredentialName is null");
        this.kmsKeyIdCredentialName = Objects.requireNonNull(kmsKeyIdCredentialName, "kmsKeyIdCredentialName is null");
        this.colonReplacement = Objects.requireNonNull(colonReplacement, "colonReplacement is null");
    }

    public Optional<S3SecurityMappingResult> getMapping(ConnectorIdentity identity, Location location) {
        S3SecurityMapping mapping = this.mappingsProvider.get().getMapping(identity, new S3Location(location)).orElseThrow(() -> new AccessDeniedException("No matching S3 security mapping"));
        if (mapping.useClusterDefault()) {
            return Optional.empty();
        }
        return Optional.of(new S3SecurityMappingResult(mapping.credentials(), this.selectRole(mapping, identity), mapping.roleSessionName().map(name -> name.replace("${USER}", identity.getUser())), this.selectKmsKeyId(mapping, identity), mapping.endpoint(), mapping.region()));
    }

    private Optional<String> selectRole(S3SecurityMapping mapping, ConnectorIdentity identity) {
        Optional<String> optionalSelected = this.getRoleFromExtraCredential(identity);
        if (optionalSelected.isEmpty()) {
            if (!mapping.allowedIamRoles().isEmpty() && mapping.iamRole().isEmpty()) {
                throw new AccessDeniedException("No S3 role selected and mapping has no default role");
            }
            Verify.verify((mapping.iamRole().isPresent() || mapping.credentials().isPresent() ? 1 : 0) != 0, (String)"mapping must have role or credential", (Object[])new Object[0]);
            return mapping.iamRole();
        }
        String selected = optionalSelected.get();
        if (!selected.equals(mapping.iamRole().orElse(null)) && !mapping.allowedIamRoles().contains(selected)) {
            throw new AccessDeniedException("Selected S3 role is not allowed: " + selected);
        }
        return optionalSelected;
    }

    private Optional<String> getRoleFromExtraCredential(ConnectorIdentity identity) {
        return this.roleCredentialName.map(name -> (String)identity.getExtraCredentials().get(name)).map(role -> this.colonReplacement.map(replacement -> role.replace((CharSequence)replacement, ":")).orElse((String)role));
    }

    private Optional<String> selectKmsKeyId(S3SecurityMapping mapping, ConnectorIdentity identity) {
        Optional<String> userSelected = this.getKmsKeyIdFromExtraCredential(identity);
        if (userSelected.isEmpty()) {
            return mapping.kmsKeyId();
        }
        String selected = userSelected.get();
        if (!(selected.equals(mapping.kmsKeyId().orElse(null)) || mapping.allowedKmsKeyIds().contains(selected) || mapping.allowedKmsKeyIds().contains("*"))) {
            throw new AccessDeniedException("Selected KMS Key ID is not allowed");
        }
        return userSelected;
    }

    private Optional<String> getKmsKeyIdFromExtraCredential(ConnectorIdentity identity) {
        return this.kmsKeyIdCredentialName.map(name -> (String)identity.getExtraCredentials().get(name));
    }

    private static Supplier<S3SecurityMappings> mappingsProvider(Supplier<S3SecurityMappings> supplier, Optional<Duration> refreshPeriod) {
        return (Supplier)refreshPeriod.map(refresh -> Suppliers.memoizeWithExpiration(((Supplier)supplier)::get, (long)refresh.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS)).orElseGet(() -> Suppliers.memoize(((Supplier)supplier)::get));
    }
}

