/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.net.URI;
import java.util.Optional;

public class S3SecurityMappingConfig {
    private File configFile;
    private URI configUri;
    private String jsonPointer = "";
    private String roleCredentialName;
    private String kmsKeyIdCredentialName;
    private Duration refreshPeriod;
    private String colonReplacement;

    public Optional<@FileExists File> getConfigFile() {
        return Optional.ofNullable(this.configFile);
    }

    @Config(value="s3.security-mapping.config-file")
    @ConfigDescription(value="Path to the JSON security mappings file")
    public S3SecurityMappingConfig setConfigFile(File configFile) {
        this.configFile = configFile;
        return this;
    }

    public Optional<URI> getConfigUri() {
        return Optional.ofNullable(this.configUri);
    }

    @Config(value="s3.security-mapping.config-uri")
    @ConfigDescription(value="HTTP URI of the JSON security mappings")
    public S3SecurityMappingConfig setConfigUri(URI configUri) {
        this.configUri = configUri;
        return this;
    }

    @NotNull
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Config(value="s3.security-mapping.json-pointer")
    @ConfigDescription(value="JSON pointer (RFC 6901) to mappings inside JSON config")
    public S3SecurityMappingConfig setJsonPointer(String jsonPointer) {
        this.jsonPointer = jsonPointer;
        return this;
    }

    public Optional<String> getRoleCredentialName() {
        return Optional.ofNullable(this.roleCredentialName);
    }

    @Config(value="s3.security-mapping.iam-role-credential-name")
    @ConfigDescription(value="Name of the extra credential used to provide IAM role")
    public S3SecurityMappingConfig setRoleCredentialName(String roleCredentialName) {
        this.roleCredentialName = roleCredentialName;
        return this;
    }

    public Optional<String> getKmsKeyIdCredentialName() {
        return Optional.ofNullable(this.kmsKeyIdCredentialName);
    }

    @Config(value="s3.security-mapping.kms-key-id-credential-name")
    @ConfigDescription(value="Name of the extra credential used to provide KMS Key ID")
    public S3SecurityMappingConfig setKmsKeyIdCredentialName(String kmsKeyIdCredentialName) {
        this.kmsKeyIdCredentialName = kmsKeyIdCredentialName;
        return this;
    }

    public Optional<Duration> getRefreshPeriod() {
        return Optional.ofNullable(this.refreshPeriod);
    }

    @Config(value="s3.security-mapping.refresh-period")
    @ConfigDescription(value="How often to refresh the security mapping configuration")
    public S3SecurityMappingConfig setRefreshPeriod(Duration refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
        return this;
    }

    public Optional<String> getColonReplacement() {
        return Optional.ofNullable(this.colonReplacement);
    }

    @Config(value="s3.security-mapping.colon-replacement")
    @ConfigDescription(value="Value used in place of colon for IAM role name in extra credentials")
    public S3SecurityMappingConfig setColonReplacement(String colonReplacement) {
        this.colonReplacement = colonReplacement;
        return this;
    }

    @AssertTrue(message="Exactly one of s3.security-mapping.config-file or s3.security-mapping.config-uri must be set")
    public @AssertTrue(message="Exactly one of s3.security-mapping.config-file or s3.security-mapping.config-uri must be set") boolean validateMappingsConfig() {
        return this.configFile == null != (this.configUri == null);
    }
}

