/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.base.VerifyException;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.binder.LinkedBindingBuilder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.units.Duration;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.s3.FileSystemS3;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.filesystem.s3.S3FileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemLoader;
import io.trino.filesystem.s3.S3FileSystemStats;
import io.trino.filesystem.s3.S3SecurityMappingConfig;
import io.trino.filesystem.s3.S3SecurityMappingEnabledConfig;
import io.trino.filesystem.s3.S3SecurityMappingProvider;
import io.trino.filesystem.s3.S3SecurityMappings;
import io.trino.filesystem.s3.S3SecurityMappingsFileSource;
import io.trino.filesystem.s3.S3SecurityMappingsUriSource;
import io.trino.filesystem.switching.SwitchingFileSystemFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.weakref.jmx.guice.ExportBinder;

public class S3FileSystemModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(S3FileSystemConfig.class);
        if (((S3SecurityMappingEnabledConfig)this.buildConfigObject(S3SecurityMappingEnabledConfig.class)).isEnabled()) {
            this.install((Module)new S3SecurityMappingModule());
        } else {
            binder.bind(TrinoFileSystemFactory.class).annotatedWith(FileSystemS3.class).to(S3FileSystemFactory.class).in(Scopes.SINGLETON);
        }
        binder.bind(S3FileSystemStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(S3FileSystemStats.class).withGeneratedName();
    }

    public static class S3SecurityMappingModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            S3SecurityMappingConfig config = (S3SecurityMappingConfig)this.buildConfigObject(S3SecurityMappingConfig.class);
            binder.bind(S3SecurityMappingProvider.class).in(Scopes.SINGLETON);
            binder.bind(S3FileSystemLoader.class).in(Scopes.SINGLETON);
            LinkedBindingBuilder mappingsBinder = binder.bind((Key)new Key<Supplier<S3SecurityMappings>>(this){});
            if (config.getConfigFile().isPresent()) {
                mappingsBinder.to(S3SecurityMappingsFileSource.class).in(Scopes.SINGLETON);
            } else if (config.getConfigUri().isPresent()) {
                mappingsBinder.to(S3SecurityMappingsUriSource.class).in(Scopes.SINGLETON);
                HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("s3-security-mapping", ForS3SecurityMapping.class).withConfigDefaults(httpConfig -> httpConfig.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS)).setSelectorCount(1).setMinThreads(1));
            } else {
                throw new VerifyException("No security mapping source configured");
            }
        }

        @Provides
        @Singleton
        @FileSystemS3
        static TrinoFileSystemFactory createFileSystemFactory(S3FileSystemLoader loader) {
            return new SwitchingFileSystemFactory((Function)loader);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface ForS3SecurityMapping {
    }
}

