/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.securityprovider.ldap;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.CedrusDataBootstrap;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.MBeanModule;
import ru.cedrusdata.catalog.securityprovider.ldap.CatalogLdapSecurityProviderConfig;
import ru.cedrusdata.catalog.securityprovider.ldap.CatalogLdapSecurityProviderModule;
import ru.cedrusdata.catalog.spi.CatalogPluginContext;
import ru.cedrusdata.catalog.spi.classloader.CatalogThreadContextClassLoader;
import ru.cedrusdata.catalog.spi.security.CatalogSecurityProvider;
import ru.cedrusdata.catalog.spi.security.CatalogSecurityProviderProvider;

public class CatalogLdapSecurityProviderProvider
implements CatalogSecurityProviderProvider {
    public String getSecurityProviderType() {
        return "ldap";
    }

    public CatalogSecurityProvider createSecurityProvider(CatalogPluginContext context, String providerName, Map<String, String> config) {
        Optional<String> error = CatalogLdapSecurityProviderConfig.validateProperties(config = config != null ? new HashMap<String, String>(config) : new HashMap(), context.resourceResolver());
        if (error.isPresent()) {
            throw (RuntimeException)context.configExceptionProvider().apply("Invalid properties: " + error.get());
        }
        ClassLoader classLoader = CatalogLdapSecurityProviderProvider.class.getClassLoader();
        try (CatalogThreadContextClassLoader ignored = new CatalogThreadContextClassLoader(classLoader);){
            CedrusDataBootstrap app = new CedrusDataBootstrap(new Module[]{new MBeanModule(), binder -> binder.bind(MBeanServer.class).toInstance((Object)ManagementFactory.getPlatformMBeanServer()), new CatalogLdapSecurityProviderModule(providerName)});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(Map.of()).setOptionalConfigurationProperties(config).quiet().initialize();
            CatalogSecurityProvider catalogSecurityProvider = (CatalogSecurityProvider)injector.getInstance(CatalogSecurityProvider.class);
            return catalogSecurityProvider;
        }
    }

    public Set<String> redactedPropertyKeys() {
        return Set.of("bind-password", "ssl-keystore-password", "ssl-truststore-password");
    }
}

