/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.RequestAccess;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsAccess;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

enum SqsAttributesGetter implements MessagingAttributesGetter<Request<?>, Response<?>>
{
    INSTANCE;


    public String getSystem(Request<?> request) {
        return "AmazonSQS";
    }

    public String getDestination(Request<?> request) {
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        String queueUrl = RequestAccess.getQueueUrl(originalRequest);
        int i = queueUrl.lastIndexOf(47);
        return i > 0 ? queueUrl.substring(i + 1) : null;
    }

    @Nullable
    public String getDestinationTemplate(Request<?> request) {
        return null;
    }

    public boolean isTemporaryDestination(Request<?> request) {
        return false;
    }

    public boolean isAnonymousDestination(Request<?> request) {
        return false;
    }

    @Nullable
    public String getConversationId(Request<?> request) {
        return null;
    }

    @Nullable
    public Long getMessageBodySize(Request<?> request) {
        return null;
    }

    @Nullable
    public Long getMessageEnvelopeSize(Request<?> request) {
        return null;
    }

    @Nullable
    public String getMessageId(Request<?> request, @Nullable Response<?> response) {
        return SqsAccess.getMessageId(response);
    }

    @Nullable
    public String getClientId(Request<?> request) {
        return null;
    }

    @Nullable
    public Long getBatchMessageCount(Request<?> request, @Nullable Response<?> response) {
        return null;
    }

    public List<String> getMessageHeader(Request<?> request, String name) {
        String value = SqsAccess.getMessageAttribute(request, name);
        return value != null ? Collections.singletonList(value) : Collections.emptyList();
    }
}

