/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkRpcAttributesGetter;
import java.util.concurrent.ConcurrentHashMap;

class AwsSdkSpanNameExtractor
implements SpanNameExtractor<Request<?>> {
    private static final AwsSdkRpcAttributesGetter rpcAttributes = AwsSdkRpcAttributesGetter.INSTANCE;
    private final NamesCache namesCache = new NamesCache();

    AwsSdkSpanNameExtractor() {
    }

    public String extract(Request<?> request) {
        return this.qualifiedOperation(rpcAttributes.getService(request), rpcAttributes.getMethod(request), request.getOriginalRequest().getClass());
    }

    private String qualifiedOperation(String service, String operation, Class<?> requestClass) {
        ConcurrentHashMap cache = (ConcurrentHashMap)this.namesCache.get(requestClass);
        return cache.computeIfAbsent(service, s -> s.replace("Amazon", "").trim() + '.' + operation);
    }

    static final class NamesCache
    extends ClassValue<ConcurrentHashMap<String, String>> {
        NamesCache() {
        }

        @Override
        protected ConcurrentHashMap<String, String> computeValue(Class<?> type) {
            return new ConcurrentHashMap<String, String>();
        }
    }
}

