/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg;

import java.util.Optional;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.responses.ImmutableLoadViewResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.view.ViewMetadata;

public class LoadObjectResponse
implements RESTResponse {
    private final TableIdentifier identifier;
    private final Optional<TableMetadata> tableMetadata;
    private final Optional<String> tableMetadataLocation;
    private final Optional<ViewMetadata> viewMetadata;
    private final Optional<String> viewMetadataLocation;

    public LoadObjectResponse(TableIdentifier identifier, Optional<TableMetadata> tableMetadata, Optional<String> tableMetadataLocation, Optional<ViewMetadata> viewMetadata, Optional<String> viewMetadataLocation) {
        this.identifier = identifier;
        this.tableMetadata = tableMetadata;
        this.tableMetadataLocation = tableMetadataLocation;
        this.viewMetadata = viewMetadata;
        this.viewMetadataLocation = viewMetadataLocation;
    }

    public Optional<LoadTableResponse> asLoadTableResponse() {
        return this.tableMetadata.map(metadata -> LoadTableResponse.builder().withTableMetadata(TableMetadata.buildFrom((TableMetadata)metadata).withMetadataLocation(this.tableMetadataLocation().get()).build()).build());
    }

    public Optional<LoadViewResponse> asLoadViewResponse() {
        return this.viewMetadata.map(metadata -> ImmutableLoadViewResponse.builder().metadata(metadata).metadataLocation(this.viewMetadataLocation.get()).build());
    }

    public TableIdentifier identifier() {
        return this.identifier;
    }

    public Optional<TableMetadata> tableMetadata() {
        return this.tableMetadata;
    }

    public Optional<String> tableMetadataLocation() {
        return this.tableMetadataLocation;
    }

    public Optional<ViewMetadata> viewMetadata() {
        return this.viewMetadata;
    }

    public Optional<String> viewMetadataLocation() {
        return this.viewMetadataLocation;
    }

    public boolean exists() {
        return this.tableMetadata.isPresent() || this.viewMetadata.isPresent();
    }

    public void validate() {
    }
}

