/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponse;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponseParser;

public class CedrusDataRESTSerializers {
    private CedrusDataRESTSerializers() {
    }

    public static void registerAll(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(LoadObjectResponse.class, new LoadObjectResponseSerializer());
        module.addDeserializer(LoadObjectResponse.class, new LoadObjectResponseDeserializer());
        mapper.registerModule((Module)module);
    }

    static class LoadObjectResponseSerializer<T extends LoadObjectResponse>
    extends JsonSerializer<T> {
        LoadObjectResponseSerializer() {
        }

        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            LoadObjectResponseParser.toJson(request, gen);
        }
    }

    static class LoadObjectResponseDeserializer<T extends LoadObjectResponse>
    extends JsonDeserializer<T> {
        LoadObjectResponseDeserializer() {
        }

        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)LoadObjectResponseParser.fromJson(jsonNode);
        }
    }
}

