/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.util.CacheableIPList;
import org.apache.hadoop.util.FileBasedIPList;
import org.apache.hadoop.util.IPList;

public class CombinedIPWhiteList
implements IPList {
    public static final Logger LOG = LoggerFactory.getLogger(CombinedIPWhiteList.class);
    private static final String LOCALHOST_IP = "127.0.0.1";
    private final IPList[] networkLists;

    public CombinedIPWhiteList(String fixedWhiteListFile, String variableWhiteListFile, long cacheExpiryInSeconds) {
        FileBasedIPList fixedNetworkList = new FileBasedIPList(fixedWhiteListFile);
        if (variableWhiteListFile != null) {
            CacheableIPList variableNetworkList = new CacheableIPList(new FileBasedIPList(variableWhiteListFile), cacheExpiryInSeconds);
            this.networkLists = new IPList[]{fixedNetworkList, variableNetworkList};
        } else {
            this.networkLists = new IPList[]{fixedNetworkList};
        }
    }

    @Override
    public boolean isIn(String ipAddress) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("ipAddress is null");
        }
        if (LOCALHOST_IP.equals(ipAddress)) {
            return true;
        }
        for (IPList networkList : this.networkLists) {
            if (!networkList.isIn(ipAddress)) continue;
            return true;
        }
        return false;
    }
}

