/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.naming.NamingException;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.DomainNameResolver;

public class DNSDomainNameResolver
implements DomainNameResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DNSDomainNameResolver.class.getName());

    @Override
    public InetAddress[] getAllByDomainName(String domainName) throws UnknownHostException {
        return InetAddress.getAllByName(domainName);
    }

    @Override
    public String getHostnameByIP(InetAddress address) {
        String host = address.getCanonicalHostName();
        if (host != null && host.length() != 0 && host.charAt(host.length() - 1) == '.') {
            host = host.substring(0, host.length() - 1);
        }
        if (host != null && host.equals(address.getHostAddress())) {
            LOG.debug("IP address returned for FQDN detected: {}", (Object)address.getHostAddress());
            try {
                return DNS.reverseDns(address, null);
            }
            catch (NamingException lookupFailure) {
                LOG.warn("Failed to perform reverse lookup: {}", (Object)address);
            }
        }
        return host;
    }

    @Override
    public String[] getAllResolvedHostnameByDomainName(String domainName, boolean useFQDN) throws UnknownHostException {
        InetAddress[] addresses = this.getAllByDomainName(domainName);
        String[] hosts = new String[addresses.length];
        if (useFQDN) {
            for (int i = 0; i < addresses.length; ++i) {
                hosts[i] = this.getHostnameByIP(addresses[i]);
            }
        } else {
            for (int i = 0; i < addresses.length; ++i) {
                hosts[i] = addresses[i].getHostAddress();
            }
        }
        return hosts;
    }
}

