/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoStreamUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.CryptoUtils;
import org.apache.hadoop.mapreduce.security.SpillCallBackInjector;

public class SpillCallBackPathsFinder
extends SpillCallBackInjector {
    private static final Logger LOG = LoggerFactory.getLogger(SpillCallBackPathsFinder.class);
    private final Map<Path, Set<Long>> encryptedSpillFiles = Collections.synchronizedMap(new ConcurrentHashMap());
    private final Map<Path, Set<Long>> spillFiles = Collections.synchronizedMap(new ConcurrentHashMap());
    private final Map<Path, Set<Long>> invalidAccessMap = Collections.synchronizedMap(new ConcurrentHashMap());
    private final Set<Path> indexSpillFiles = ConcurrentHashMap.newKeySet();
    private final Set<Path> negativeCache = ConcurrentHashMap.newKeySet();

    protected Map<Path, Set<Long>> getFilesMap(Configuration config) {
        if (CryptoUtils.isEncryptedSpillEnabled(config)) {
            return this.encryptedSpillFiles;
        }
        return this.spillFiles;
    }

    @Override
    public void writeSpillFileCB(Path path, FSDataOutputStream out, Configuration conf) {
        long outPos = out.getPos();
        this.getFilesMap(conf).computeIfAbsent(path, p -> ConcurrentHashMap.newKeySet()).add(outPos);
        LOG.debug("writeSpillFileCB.. path:{}; pos:{}", (Object)path, (Object)outPos);
    }

    @Override
    public void getSpillFileCB(Path path, InputStream is, Configuration conf) {
        if (path == null) {
            return;
        }
        Set<Long> pathEntries = this.getFilesMap(conf).get(path);
        if (pathEntries != null) {
            try {
                long isPos = CryptoStreamUtils.getInputStreamOffset(is);
                if (pathEntries.contains(isPos)) {
                    LOG.debug("getSpillFileCB... Path {}; Pos: {}", (Object)path, (Object)isPos);
                    return;
                }
                this.invalidAccessMap.computeIfAbsent(path, p -> ConcurrentHashMap.newKeySet()).add(isPos);
                LOG.debug("getSpillFileCB... access incorrect position.. Path {}; Pos: {}", (Object)path, (Object)isPos);
            }
            catch (IOException e) {
                LOG.error("Could not get inputStream position.. Path {}", (Object)path, (Object)e);
            }
            return;
        }
        this.negativeCache.add(path);
        LOG.warn("getSpillFileCB.. Could not find spilled file .. Path: {}", (Object)path);
    }

    @Override
    public String getSpilledFileReport() {
        StringBuilder strBuilder = new StringBuilder("\n++++++++ Spill Report ++++++++").append(this.dumpMapEntries("Encrypted Spilled Files", this.encryptedSpillFiles)).append(this.dumpMapEntries("Non-Encrypted Spilled Files", this.spillFiles)).append(this.dumpMapEntries("Invalid Spill Access", this.invalidAccessMap)).append("\n ----- Spilled Index Files ----- ").append(this.indexSpillFiles.size());
        for (Path p : this.indexSpillFiles) {
            strBuilder.append("\n\t index-path: ").append(p.toString());
        }
        strBuilder.append("\n ----- Negative Cache files ----- ").append(this.negativeCache.size());
        for (Path p : this.negativeCache) {
            strBuilder.append("\n\t path: ").append(p.toString());
        }
        return strBuilder.toString();
    }

    @Override
    public void addSpillIndexFileCB(Path path, Configuration conf) {
        if (path == null) {
            return;
        }
        this.indexSpillFiles.add(path);
        LOG.debug("addSpillIndexFileCB... Path: {}", (Object)path);
    }

    @Override
    public void validateSpillIndexFileCB(Path path, Configuration conf) {
        if (path == null) {
            return;
        }
        if (this.indexSpillFiles.contains(path)) {
            LOG.debug("validateSpillIndexFileCB.. Path: {}", (Object)path);
            return;
        }
        LOG.warn("validateSpillIndexFileCB.. could not retrieve indexFile.. Path: {}", (Object)path);
        this.negativeCache.add(path);
    }

    public Set<Path> getEncryptedSpilledFiles() {
        return Collections.unmodifiableSet(this.encryptedSpillFiles.keySet());
    }

    public Set<String> getInvalidSpillEntries() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Map.Entry<Path, Set<Long>> spillMapEntry : this.invalidAccessMap.entrySet()) {
            for (Long singleEntry : spillMapEntry.getValue()) {
                result.add(String.format("%s[%d]", spillMapEntry.getKey(), singleEntry));
            }
        }
        return result;
    }

    private String dumpMapEntries(String label, Map<Path, Set<Long>> entriesMap) {
        StringBuilder strBuilder = new StringBuilder(String.format("%n ----- %s ----- %d", label, entriesMap.size()));
        for (Map.Entry<Path, Set<Long>> encryptedSpillEntry : entriesMap.entrySet()) {
            strBuilder.append(String.format("%n\t\tpath: %s", encryptedSpillEntry.getKey()));
            for (Long singlePos : encryptedSpillEntry.getValue()) {
                strBuilder.append(String.format("%n\t\t\tentry: %d", singlePos));
            }
        }
        return strBuilder.toString();
    }
}

