/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class ProcessingDetails {
    public static final Logger LOG = LoggerFactory.getLogger(ProcessingDetails.class);
    private final TimeUnit valueTimeUnit;
    private long[] timings = new long[Timing.values().length];

    ProcessingDetails(TimeUnit timeUnit) {
        this.valueTimeUnit = timeUnit;
    }

    public long get(Timing type) {
        long ret = this.timings[type.ordinal()];
        return ret < 0L ? 0L : ret;
    }

    public long get(Timing type, TimeUnit timeUnit) {
        return timeUnit.convert(this.get(type), this.valueTimeUnit);
    }

    public void set(Timing type, long value) {
        this.timings[type.ordinal()] = value;
    }

    public void set(Timing type, long value, TimeUnit timeUnit) {
        this.set(type, this.valueTimeUnit.convert(value, timeUnit));
    }

    public void add(Timing type, long value, TimeUnit timeUnit) {
        int n = type.ordinal();
        this.timings[n] = this.timings[n] + this.valueTimeUnit.convert(value, timeUnit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        for (Timing type : Timing.values()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(type.name().toLowerCase()).append("Time=").append(this.get(type));
        }
        return sb.toString();
    }

    public static enum Timing {
        ENQUEUE,
        QUEUE,
        HANDLER,
        PROCESSING,
        LOCKFREE,
        LOCKWAIT,
        LOCKSHARED,
        LOCKEXCLUSIVE,
        RESPONSE;

    }
}

