/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.ha.ShellCommandFencer;

class StreamPumper {
    private final Logger log;
    final Thread thread;
    final String logPrefix;
    final StreamType type;
    private final InputStream stream;
    private boolean started = false;

    StreamPumper(Logger log, final String logPrefix, InputStream stream, final StreamType type) {
        this.log = log;
        this.logPrefix = logPrefix;
        this.stream = stream;
        this.type = type;
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StreamPumper.this.pump();
                }
                catch (Throwable t) {
                    ShellCommandFencer.LOG.warn(logPrefix + ": Unable to pump output from " + (Object)((Object)type), t);
                }
            }
        }, logPrefix + ": StreamPumper for " + (Object)((Object)type));
        this.thread.setDaemon(true);
    }

    void join() throws InterruptedException {
        assert (this.started);
        this.thread.join();
    }

    void start() {
        assert (!this.started);
        this.thread.start();
        this.started = true;
    }

    protected void pump() throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(this.stream, StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(inputStreamReader);
        String line = null;
        while ((line = br.readLine()) != null) {
            if (this.type == StreamType.STDOUT) {
                this.log.info(this.logPrefix + ": " + line);
                continue;
            }
            this.log.warn(this.logPrefix + ": " + line);
        }
    }

    static enum StreamType {
        STDOUT,
        STDERR;

    }
}

