/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;

public class MsiTokenProvider
extends AccessTokenProvider {
    private final String authEndpoint;
    private final String authority;
    private final String tenantGuid;
    private final String clientId;
    private long tokenFetchTime = -1L;
    private static final long ONE_HOUR = 3600000L;
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);

    public MsiTokenProvider(String authEndpoint, String tenantGuid, String clientId, String authority) {
        this.authEndpoint = authEndpoint;
        this.tenantGuid = tenantGuid;
        this.clientId = clientId;
        this.authority = authority;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        LOG.debug("AADToken: refreshing token from MSI");
        AzureADToken token = AzureADAuthenticator.getTokenFromMsi(this.authEndpoint, this.tenantGuid, this.clientId, this.authority, false);
        this.tokenFetchTime = System.currentTimeMillis();
        return token;
    }

    @Override
    protected boolean isTokenAboutToExpire() {
        if (this.tokenFetchTime == -1L || super.isTokenAboutToExpire()) {
            return true;
        }
        boolean expiring = false;
        long elapsedTimeSinceLastTokenRefreshInMillis = System.currentTimeMillis() - this.tokenFetchTime;
        boolean bl = expiring = elapsedTimeSinceLastTokenRefreshInMillis >= 3600000L || elapsedTimeSinceLastTokenRefreshInMillis < 0L;
        if (expiring) {
            LOG.debug("MSIToken: token renewing. Time elapsed since last token fetch: {} milli seconds", (Object)elapsedTimeSinceLastTokenRefreshInMillis);
        }
        return expiring;
    }
}

