/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsUrlStreamHandler;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FsUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FsUrlStreamHandlerFactory.class);
    public static final String[] UNEXPORTED_PROTOCOLS = new String[]{"http", "https"};
    private Configuration conf;
    private Map<String, Boolean> protocols = new ConcurrentHashMap<String, Boolean>();
    private URLStreamHandler handler;

    public FsUrlStreamHandlerFactory() {
        this(new Configuration());
    }

    public FsUrlStreamHandlerFactory(Configuration conf) {
        this.conf = new Configuration(conf);
        try {
            FileSystem.getFileSystemClass("file", conf);
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        this.handler = new FsUrlStreamHandler(this.conf);
        for (String protocol : UNEXPORTED_PROTOCOLS) {
            this.protocols.put(protocol, false);
        }
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        LOG.debug("Creating handler for protocol {}", (Object)protocol);
        if (!this.protocols.containsKey(protocol)) {
            boolean known = true;
            try {
                Class<? extends FileSystem> impl = FileSystem.getFileSystemClass(protocol, this.conf);
                LOG.debug("Found implementation of {}: {}", (Object)protocol, (Object)impl);
            }
            catch (IOException ex) {
                known = false;
            }
            this.protocols.put(protocol, known);
        }
        if (this.protocols.get(protocol).booleanValue()) {
            LOG.debug("Using handler for protocol {}", (Object)protocol);
            return this.handler;
        }
        LOG.debug("Unknown protocol {}, delegating to default implementation", (Object)protocol);
        return null;
    }
}

