/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.ConfigRedactor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.conf.Reconfigurable;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.util.Time;

public abstract class ReconfigurableBase
extends Configured
implements Reconfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigurableBase.class);
    private ReconfigurationUtil reconfigurationUtil = new ReconfigurationUtil();
    private Thread reconfigThread = null;
    private volatile boolean shouldRun = true;
    private Object reconfigLock = new Object();
    private long startTime = 0L;
    private long endTime = 0L;
    private Map<ReconfigurationUtil.PropertyChange, Optional<String>> status = null;

    public ReconfigurableBase() {
        super(new Configuration());
    }

    public ReconfigurableBase(Configuration conf) {
        super(conf == null ? new Configuration() : conf);
    }

    @.VisibleForTesting
    public void setReconfigurationUtil(ReconfigurationUtil ru) {
        this.reconfigurationUtil = Preconditions.checkNotNull(ru);
    }

    protected abstract Configuration getNewConf();

    @.VisibleForTesting
    public Collection<ReconfigurationUtil.PropertyChange> getChangedProperties(Configuration newConf, Configuration oldConf) {
        return this.reconfigurationUtil.parseChangedProperties(newConf, oldConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReconfigurationTask() throws IOException {
        Object object = this.reconfigLock;
        synchronized (object) {
            if (!this.shouldRun) {
                String errorMessage = "The server is stopped.";
                LOG.warn(errorMessage);
                throw new IOException(errorMessage);
            }
            if (this.reconfigThread != null) {
                String errorMessage = "Another reconfiguration task is running.";
                LOG.warn(errorMessage);
                throw new IOException(errorMessage);
            }
            this.reconfigThread = new ReconfigurationThread(this);
            this.reconfigThread.setDaemon(true);
            this.reconfigThread.setName("Reconfiguration Task");
            this.reconfigThread.start();
            this.startTime = Time.now();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReconfigurationTaskStatus getReconfigurationTaskStatus() {
        Object object = this.reconfigLock;
        synchronized (object) {
            if (this.reconfigThread != null) {
                return new ReconfigurationTaskStatus(this.startTime, 0L, null);
            }
            return new ReconfigurationTaskStatus(this.startTime, this.endTime, this.status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReconfigurationTask() {
        Thread tempThread;
        Object object = this.reconfigLock;
        synchronized (object) {
            this.shouldRun = false;
            if (this.reconfigThread == null) {
                return;
            }
            tempThread = this.reconfigThread;
            this.reconfigThread = null;
        }
        try {
            tempThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reconfigureProperty(String property, String newVal) throws ReconfigurationException {
        if (this.isPropertyReconfigurable(property)) {
            LOG.info("changing property " + property + " to " + newVal);
            Configuration configuration = this.getConf();
            synchronized (configuration) {
                this.getConf().get(property);
                String effectiveValue = this.reconfigurePropertyImpl(property, newVal);
                if (newVal != null) {
                    this.getConf().set(property, effectiveValue);
                } else {
                    this.getConf().unset(property);
                }
            }
        } else {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property));
        }
    }

    @Override
    public abstract Collection<String> getReconfigurableProperties();

    @Override
    public boolean isPropertyReconfigurable(String property) {
        return this.getReconfigurableProperties().contains(property);
    }

    protected abstract String reconfigurePropertyImpl(String var1, String var2) throws ReconfigurationException;

    private static class ReconfigurationThread
    extends Thread {
        private ReconfigurableBase parent;

        ReconfigurationThread(ReconfigurableBase base) {
            this.parent = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("Starting reconfiguration task.");
            Configuration oldConf = this.parent.getConf();
            Configuration newConf = this.parent.getNewConf();
            Collection<ReconfigurationUtil.PropertyChange> changes = this.parent.getChangedProperties(newConf, oldConf);
            HashMap<ReconfigurationUtil.PropertyChange, Optional<String>> results = Maps.newHashMap();
            ConfigRedactor oldRedactor = new ConfigRedactor(oldConf);
            ConfigRedactor newRedactor = new ConfigRedactor(newConf);
            for (ReconfigurationUtil.PropertyChange change : changes) {
                String errorMessage = null;
                String oldValRedacted = oldRedactor.redact(change.prop, change.oldVal);
                String newValRedacted = newRedactor.redact(change.prop, change.newVal);
                if (!this.parent.isPropertyReconfigurable(change.prop)) {
                    LOG.info(String.format("Property %s is not configurable: old value: %s, new value: %s", change.prop, oldValRedacted, newValRedacted));
                    continue;
                }
                LOG.info("Change property: " + change.prop + " from \"" + (change.oldVal == null ? "<default>" : oldValRedacted) + "\" to \"" + (change.newVal == null ? "<default>" : newValRedacted) + "\".");
                try {
                    String effectiveValue = this.parent.reconfigurePropertyImpl(change.prop, change.newVal);
                    if (change.newVal != null) {
                        oldConf.set(change.prop, effectiveValue);
                    } else {
                        oldConf.unset(change.prop);
                    }
                }
                catch (ReconfigurationException e) {
                    Throwable cause = e.getCause();
                    errorMessage = cause == null ? e.getMessage() : cause.getMessage();
                }
                results.put(change, Optional.ofNullable(errorMessage));
            }
            Object object = this.parent.reconfigLock;
            synchronized (object) {
                this.parent.endTime = Time.now();
                this.parent.status = Collections.unmodifiableMap(results);
                this.parent.reconfigThread = null;
            }
        }
    }
}

