/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base;

import io.trino.hadoop.$internal.org.apache.kerby.asn1.Asn1FieldInfo;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.EnumType;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.ExplicitField;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Integer;
import io.trino.hadoop.$internal.org.apache.kerby.asn1.type.Asn1OctetString;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.CheckSumType;
import java.util.Arrays;

public class CheckSum
extends KrbSequenceType {
    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField(CheckSumField.CKSUM_TYPE, Asn1Integer.class), new ExplicitField(CheckSumField.CHECK_SUM, Asn1OctetString.class)};

    public CheckSum() {
        super(fieldInfos);
    }

    public CheckSum(CheckSumType cksumType, byte[] checksum) {
        super(fieldInfos);
        this.setCksumtype(cksumType);
        this.setChecksum(checksum);
    }

    public CheckSum(int cksumType, byte[] checksum) {
        this(CheckSumType.fromValue(cksumType), checksum);
    }

    public CheckSumType getCksumtype() {
        Integer value = this.getFieldAsInteger(CheckSumField.CKSUM_TYPE);
        return CheckSumType.fromValue(value);
    }

    public void setCksumtype(CheckSumType cksumtype) {
        this.setFieldAsInt((EnumType)CheckSumField.CKSUM_TYPE, cksumtype.getValue());
    }

    public byte[] getChecksum() {
        return this.getFieldAsOctets(CheckSumField.CHECK_SUM);
    }

    public void setChecksum(byte[] checksum) {
        this.setFieldAsOctets(CheckSumField.CHECK_SUM, checksum);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CheckSum)) {
            return false;
        }
        CheckSum that = (CheckSum)other;
        return this.getCksumtype() == that.getCksumtype() && Arrays.equals(this.getChecksum(), that.getChecksum());
    }

    public int hashCode() {
        int result = 17;
        if (this.getCksumtype() != null) {
            result = 31 * result + this.getCksumtype().hashCode();
        }
        if (this.getChecksum() != null) {
            result = 31 * result + Arrays.hashCode(this.getChecksum());
        }
        return result;
    }

    public boolean isEqual(CheckSum other) {
        return this.equals(other);
    }

    public boolean isEqual(byte[] cksumBytes) {
        return Arrays.equals(this.getChecksum(), cksumBytes);
    }

    protected static enum CheckSumField implements EnumType
    {
        CKSUM_TYPE,
        CHECK_SUM;


        @Override
        public int getValue() {
            return this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

