/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.identity.backend;

import io.trino.hadoop.$internal.org.apache.kerby.config.Configured;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.identity.BatchTrans;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.identity.KrbIdentity;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.identity.backend.BackendConfig;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.identity.backend.IdentityBackend;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad.AdToken;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationDataEntry;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationType;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KrbToken;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.TokenFormat;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.KdcClientRequest;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ticket.EncTicketPart;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Collections;

public abstract class AbstractIdentityBackend
extends Configured
implements IdentityBackend {
    private static Logger logger = LoggerFactory.getLogger(AbstractIdentityBackend.class);

    protected BackendConfig getBackendConfig() {
        return (BackendConfig)this.getConfig();
    }

    @Override
    public void initialize() throws KrbException {
        logger.debug("initialize called");
        this.doInitialize();
    }

    @Override
    public boolean supportBatchTrans() {
        return false;
    }

    @Override
    public BatchTrans startBatchTrans() throws KrbException {
        throw new KrbException("Transaction isn't supported");
    }

    protected void doInitialize() throws KrbException {
    }

    @Override
    public void start() {
        this.doStart();
        logger.debug("start called");
    }

    protected void doStart() {
    }

    @Override
    public void stop() throws KrbException {
        this.doStop();
        logger.debug("stop called");
    }

    protected void doStop() throws KrbException {
    }

    @Override
    public void release() {
        this.doRelease();
        logger.debug("release called");
    }

    protected void doRelease() {
    }

    @Override
    public Iterable<String> getIdentities() throws KrbException {
        logger.debug("getIdentities called");
        return this.doGetIdentities();
    }

    protected abstract Iterable<String> doGetIdentities() throws KrbException;

    @Override
    public KrbIdentity getIdentity(String principalName) throws KrbException {
        if (principalName == null || principalName.isEmpty()) {
            throw new IllegalArgumentException("Invalid principal name");
        }
        logger.debug("getIdentity called, principalName = {}", (Object)principalName);
        KrbIdentity identity = this.doGetIdentity(principalName);
        logger.debug("getIdentity {}, principalName = {}", (Object)(identity != null ? "successful" : "failed"), (Object)principalName);
        return identity;
    }

    protected abstract KrbIdentity doGetIdentity(String var1) throws KrbException;

    @Override
    public AuthorizationData getIdentityAuthorizationData(KdcClientRequest kdcClientRequest, EncTicketPart encTicketPart) throws KrbException {
        if (kdcClientRequest == null) {
            throw new IllegalArgumentException("Invalid identity");
        }
        logger.debug("getIdentityAuthorizationData called, krbIdentity = {}", (Object)kdcClientRequest.getClientPrincipal());
        AuthorizationData authData = this.doGetIdentityAuthorizationData(kdcClientRequest, encTicketPart);
        logger.debug("getIdentityAuthorizationData {}, authData = {}", (Object)(authData != null ? "successful" : "failed"), (Object)authData);
        return authData;
    }

    protected AuthorizationData doGetIdentityAuthorizationData(KdcClientRequest kdcClientRequest, EncTicketPart encTicketPart) throws KrbException {
        if (kdcClientRequest.isToken()) {
            KrbToken krbToken = new KrbToken(kdcClientRequest.getToken(), TokenFormat.JWT);
            AdToken adToken = new AdToken();
            adToken.setToken(krbToken);
            AuthorizationData authzData = new AuthorizationData();
            AuthorizationDataEntry authzDataEntry = new AuthorizationDataEntry();
            try {
                authzDataEntry.setAuthzData(adToken.encode());
            }
            catch (IOException e) {
                throw new KrbException("Error encoding AdToken", (Throwable)e);
            }
            authzDataEntry.setAuthzType(AuthorizationType.AD_TOKEN);
            authzData.setElements(Collections.singletonList(authzDataEntry));
            return authzData;
        }
        return null;
    }

    @Override
    public KrbIdentity addIdentity(KrbIdentity identity) throws KrbException {
        if (identity == null) {
            throw new IllegalArgumentException("null identity to add");
        }
        if (this.doGetIdentity(identity.getPrincipalName()) != null) {
            throw new KrbException("Principal already exists: " + identity.getPrincipalName());
        }
        KrbIdentity added = this.doAddIdentity(identity);
        logger.debug("addIdentity {}, principalName = {}", (Object)(added != null ? "successful" : "failed"), (Object)identity.getPrincipalName());
        return added;
    }

    protected abstract KrbIdentity doAddIdentity(KrbIdentity var1) throws KrbException;

    @Override
    public KrbIdentity updateIdentity(KrbIdentity identity) throws KrbException {
        if (identity == null) {
            throw new IllegalArgumentException("null identity to update");
        }
        if (this.doGetIdentity(identity.getPrincipalName()) == null) {
            logger.error("Error occurred while updating identity, principal " + identity.getPrincipalName() + " does not exists.");
            throw new KrbException("Principal does not exist.");
        }
        KrbIdentity updated = this.doUpdateIdentity(identity);
        logger.debug("updateIdentity {}, principalName = {}", (Object)(updated != null ? "successful" : "failed"), (Object)identity.getPrincipalName());
        return updated;
    }

    protected abstract KrbIdentity doUpdateIdentity(KrbIdentity var1) throws KrbException;

    @Override
    public void deleteIdentity(String principalName) throws KrbException {
        logger.debug("deleteIdentity called, principalName = {}", (Object)principalName);
        if (principalName == null) {
            throw new IllegalArgumentException("null identity to remove");
        }
        if (this.doGetIdentity(principalName) == null) {
            logger.error("Error occurred while deleting identity, principal " + principalName + " does not exists.");
            throw new KrbException("Principal does not exist.");
        }
        this.doDeleteIdentity(principalName);
    }

    protected abstract void doDeleteIdentity(String var1) throws KrbException;
}

