/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.commons.configuration2;

import io.trino.hadoop.$internal.org.apache.commons.configuration2.BaseConfiguration;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.Configuration;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.MapConfiguration;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.PropertiesConfiguration;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.XMLPropertiesConfiguration;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.ex.ConfigurationException;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.io.FileBased;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.io.FileHandler;
import io.trino.hadoop.$internal.org.apache.commons.logging.Log;
import io.trino.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.util.Iterator;

public class SystemConfiguration
extends MapConfiguration {
    private static final Log LOG = LogFactory.getLog(SystemConfiguration.class);

    public SystemConfiguration() {
        super(System.getProperties());
    }

    public static void setSystemProperties(String fileName) throws ConfigurationException {
        SystemConfiguration.setSystemProperties(null, fileName);
    }

    public static void setSystemProperties(String basePath, String fileName) throws ConfigurationException {
        BaseConfiguration config = fileName.endsWith(".xml") ? new XMLPropertiesConfiguration() : new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)((Object)config));
        handler.setBasePath(basePath);
        handler.setFileName(fileName);
        handler.load();
        SystemConfiguration.setSystemProperties(config);
    }

    public static void setSystemProperties(Configuration systemConfig) {
        Iterator<String> iter = systemConfig.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            String value = (String)systemConfig.getProperty(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting system property " + key + " to " + value);
            }
            System.setProperty(key, value);
        }
    }

    @Override
    protected Iterator<String> getKeysInternal() {
        return System.getProperties().stringPropertyNames().iterator();
    }
}

