/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="ServerInfo")
public class ServerInfo {
    private final String version;
    private final Boolean initialized;

    @JsonCreator
    public ServerInfo(@JsonProperty(value="version") String version, @JsonProperty(value="initialized") Boolean initialized) {
        this.version = version;
        this.initialized = initialized;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="initialized")
    public Boolean getInitialized() {
        return this.initialized;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInfo serverInfo = (ServerInfo)o;
        return Objects.equals(this.version, serverInfo.version) && Objects.equals(this.initialized, serverInfo.initialized);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.initialized);
    }

    public String toString() {
        return "ServerInfo{version='" + this.version + "', initialized='" + this.initialized + "'}";
    }

    public static class Builder {
        private String version;
        private Boolean initialized;

        private Builder() {
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setInitialized(Boolean initialized) {
            this.initialized = initialized;
            return this;
        }

        public ServerInfo build() {
            return new ServerInfo(this.version, this.initialized);
        }
    }
}

