/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonTypeName(value="SecurityProviderInfo")
public class SecurityProviderInfo {
    private final String securityProviderName;
    private final String type;
    private final String owner;
    private final String description;
    private final Map<String, String> properties;
    private final Set<String> redactedProperties;

    @JsonCreator
    public SecurityProviderInfo(@JsonProperty(value="security-provider-name") String securityProviderName, @JsonProperty(value="type") String type, @JsonProperty(value="owner") String owner, @JsonProperty(value="description") String description, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="redactedProperties") Set<String> redactedProperties) {
        this.securityProviderName = securityProviderName;
        this.type = type;
        this.owner = owner;
        this.description = description;
        this.properties = properties;
        this.redactedProperties = redactedProperties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="security-provider-name")
    public String getSecurityProviderName() {
        return this.securityProviderName;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="redactedProperties")
    public Set<String> getRedactedProperties() {
        return this.redactedProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityProviderInfo securityProviderInfo = (SecurityProviderInfo)o;
        return Objects.equals(this.securityProviderName, securityProviderInfo.securityProviderName) && Objects.equals(this.type, securityProviderInfo.type) && Objects.equals(this.owner, securityProviderInfo.owner) && Objects.equals(this.description, securityProviderInfo.description) && Objects.equals(this.properties, securityProviderInfo.properties) && Objects.equals(this.redactedProperties, securityProviderInfo.redactedProperties);
    }

    public int hashCode() {
        return Objects.hash(this.securityProviderName, this.type, this.owner, this.description, this.properties, this.redactedProperties);
    }

    public String toString() {
        return "SecurityProviderInfo{securityProviderName='" + this.securityProviderName + "', type='" + this.type + "', owner='" + this.owner + "', description='" + this.description + "', properties='" + String.valueOf(this.properties) + "', redactedProperties='" + String.valueOf(this.redactedProperties) + "'}";
    }

    public static class Builder {
        private String securityProviderName;
        private String type;
        private String owner;
        private String description;
        private Map<String, String> properties;
        private Set<String> redactedProperties;

        private Builder() {
        }

        public Builder setSecurityProviderName(String securityProviderName) {
            this.securityProviderName = securityProviderName;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder setRedactedProperties(Set<String> redactedProperties) {
            this.redactedProperties = redactedProperties;
            return this;
        }

        public SecurityProviderInfo build() {
            return new SecurityProviderInfo(this.securityProviderName, this.type, this.owner, this.description, this.properties, this.redactedProperties);
        }
    }
}

