/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import java.util.Set;

@JsonTypeName(value="PrivilegeTypeInfo")
public class PrivilegeTypeInfo {
    private final String privilege;
    private final String securableType;
    private final Set<String> impliedPrivileges;

    @JsonCreator
    public PrivilegeTypeInfo(@JsonProperty(value="privilege") String privilege, @JsonProperty(value="securable-type") String securableType, @JsonProperty(value="implied-privileges") Set<String> impliedPrivileges) {
        this.privilege = privilege;
        this.securableType = securableType;
        this.impliedPrivileges = impliedPrivileges;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="privilege")
    public String getPrivilege() {
        return this.privilege;
    }

    @JsonProperty(value="securable-type")
    public String getSecurableType() {
        return this.securableType;
    }

    @JsonProperty(value="implied-privileges")
    public Set<String> getImpliedPrivileges() {
        return this.impliedPrivileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeTypeInfo privilegeTypeInfo = (PrivilegeTypeInfo)o;
        return Objects.equals(this.privilege, privilegeTypeInfo.privilege) && Objects.equals(this.securableType, privilegeTypeInfo.securableType) && Objects.equals(this.impliedPrivileges, privilegeTypeInfo.impliedPrivileges);
    }

    public int hashCode() {
        return Objects.hash(this.privilege, this.securableType, this.impliedPrivileges);
    }

    public String toString() {
        return "PrivilegeTypeInfo{privilege='" + this.privilege + "', securableType='" + this.securableType + "', impliedPrivileges='" + String.valueOf(this.impliedPrivileges) + "'}";
    }

    public static class Builder {
        private String privilege;
        private String securableType;
        private Set<String> impliedPrivileges;

        private Builder() {
        }

        public Builder setPrivilege(String privilege) {
            this.privilege = privilege;
            return this;
        }

        public Builder setSecurableType(String securableType) {
            this.securableType = securableType;
            return this;
        }

        public Builder setImpliedPrivileges(Set<String> impliedPrivileges) {
            this.impliedPrivileges = impliedPrivileges;
            return this;
        }

        public PrivilegeTypeInfo build() {
            return new PrivilegeTypeInfo(this.privilege, this.securableType, this.impliedPrivileges);
        }
    }
}

