/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="ObjectGroupObjectInfo")
public class ObjectGroupObjectInfo {
    private final String catalogName;
    private final String namespaceName;
    private final String objectName;
    private final String objectType;

    @JsonCreator
    public ObjectGroupObjectInfo(@JsonProperty(value="catalog-name") String catalogName, @JsonProperty(value="namespace-name") String namespaceName, @JsonProperty(value="object-name") String objectName, @JsonProperty(value="object-type") String objectType) {
        this.catalogName = catalogName;
        this.namespaceName = namespaceName;
        this.objectName = objectName;
        this.objectType = objectType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="catalog-name")
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="namespace-name")
    public String getNamespaceName() {
        return this.namespaceName;
    }

    @JsonProperty(value="object-name")
    public String getObjectName() {
        return this.objectName;
    }

    @JsonProperty(value="object-type")
    public String getObjectType() {
        return this.objectType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectGroupObjectInfo objectGroupObjectInfo = (ObjectGroupObjectInfo)o;
        return Objects.equals(this.catalogName, objectGroupObjectInfo.catalogName) && Objects.equals(this.namespaceName, objectGroupObjectInfo.namespaceName) && Objects.equals(this.objectName, objectGroupObjectInfo.objectName) && Objects.equals(this.objectType, objectGroupObjectInfo.objectType);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.namespaceName, this.objectName, this.objectType);
    }

    public String toString() {
        return "ObjectGroupObjectInfo{catalogName='" + this.catalogName + "', namespaceName='" + this.namespaceName + "', objectName='" + this.objectName + "', objectType='" + this.objectType + "'}";
    }

    public static class Builder {
        private String catalogName;
        private String namespaceName;
        private String objectName;
        private String objectType;

        private Builder() {
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder setObjectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder setObjectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public ObjectGroupObjectInfo build() {
            return new ObjectGroupObjectInfo(this.catalogName, this.namespaceName, this.objectName, this.objectType);
        }
    }
}

