/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="JobScheduleConfig")
public class JobScheduleConfig {
    private final String scheduleExpression;
    private final String timeZoneId;

    @JsonCreator
    public JobScheduleConfig(@JsonProperty(value="schedule-expression") String scheduleExpression, @JsonProperty(value="schedule-time-zone-id") String timeZoneId) {
        this.scheduleExpression = scheduleExpression;
        this.timeZoneId = timeZoneId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="schedule-expression")
    public String getScheduleExpression() {
        return this.scheduleExpression;
    }

    @JsonProperty(value="schedule-time-zone-id")
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobScheduleConfig jobScheduleConfig = (JobScheduleConfig)o;
        return Objects.equals(this.scheduleExpression, jobScheduleConfig.scheduleExpression) && Objects.equals(this.timeZoneId, jobScheduleConfig.timeZoneId);
    }

    public int hashCode() {
        return Objects.hash(this.scheduleExpression, this.timeZoneId);
    }

    public String toString() {
        return "JobScheduleConfig{scheduleExpression='" + this.scheduleExpression + "', timeZoneId='" + this.timeZoneId + "'}";
    }

    public static class Builder {
        private String scheduleExpression;
        private String timeZoneId;

        private Builder() {
        }

        public Builder setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public Builder setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public JobScheduleConfig build() {
            return new JobScheduleConfig(this.scheduleExpression, this.timeZoneId);
        }
    }
}

