/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonTypeName(value="FileSystemInfo")
public class FileSystemInfo {
    private final String fileSystemName;
    private final String type;
    private final String owner;
    private final String description;
    private final Map<String, String> properties;
    private final Set<String> redactedProperties;

    @JsonCreator
    public FileSystemInfo(@JsonProperty(value="file-system-name") String fileSystemName, @JsonProperty(value="type") String type, @JsonProperty(value="owner") String owner, @JsonProperty(value="description") String description, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="redactedProperties") Set<String> redactedProperties) {
        this.fileSystemName = fileSystemName;
        this.type = type;
        this.owner = owner;
        this.description = description;
        this.properties = properties;
        this.redactedProperties = redactedProperties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="file-system-name")
    public String getFileSystemName() {
        return this.fileSystemName;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="redactedProperties")
    public Set<String> getRedactedProperties() {
        return this.redactedProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemInfo fileSystemInfo = (FileSystemInfo)o;
        return Objects.equals(this.fileSystemName, fileSystemInfo.fileSystemName) && Objects.equals(this.type, fileSystemInfo.type) && Objects.equals(this.owner, fileSystemInfo.owner) && Objects.equals(this.description, fileSystemInfo.description) && Objects.equals(this.properties, fileSystemInfo.properties) && Objects.equals(this.redactedProperties, fileSystemInfo.redactedProperties);
    }

    public int hashCode() {
        return Objects.hash(this.fileSystemName, this.type, this.owner, this.description, this.properties, this.redactedProperties);
    }

    public String toString() {
        return "FileSystemInfo{fileSystemName='" + this.fileSystemName + "', type='" + this.type + "', owner='" + this.owner + "', description='" + this.description + "', properties='" + String.valueOf(this.properties) + "', redactedProperties='" + String.valueOf(this.redactedProperties) + "'}";
    }

    public static class Builder {
        private String fileSystemName;
        private String type;
        private String owner;
        private String description;
        private Map<String, String> properties;
        private Set<String> redactedProperties;

        private Builder() {
        }

        public Builder setFileSystemName(String fileSystemName) {
            this.fileSystemName = fileSystemName;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder setRedactedProperties(Set<String> redactedProperties) {
            this.redactedProperties = redactedProperties;
            return this;
        }

        public FileSystemInfo build() {
            return new FileSystemInfo(this.fileSystemName, this.type, this.owner, this.description, this.properties, this.redactedProperties);
        }
    }
}

