/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.ComputeEngineInfo;

@JsonTypeName(value="ComputeEngineListResponse")
public class ComputeEngineListResponse {
    private final List<ComputeEngineInfo> items;
    private final String nextPageToken;

    @JsonCreator
    public ComputeEngineListResponse(@JsonProperty(value="items") List<ComputeEngineInfo> items, @JsonProperty(value="next-page-token") String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="items")
    public List<ComputeEngineInfo> getItems() {
        return this.items;
    }

    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputeEngineListResponse computeEngineListResponse = (ComputeEngineListResponse)o;
        return Objects.equals(this.items, computeEngineListResponse.items) && Objects.equals(this.nextPageToken, computeEngineListResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken);
    }

    public String toString() {
        return "ComputeEngineListResponse{items='" + String.valueOf(this.items) + "', nextPageToken='" + this.nextPageToken + "'}";
    }

    public static class Builder {
        private List<ComputeEngineInfo> items;
        private String nextPageToken;

        private Builder() {
        }

        public Builder setItems(List<ComputeEngineInfo> items) {
            this.items = items;
            return this;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public ComputeEngineListResponse build() {
            return new ComputeEngineListResponse(this.items, this.nextPageToken);
        }
    }
}

