/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception.iceberg;

import java.util.Map;
import java.util.Optional;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;
import ru.cedrusdata.catalog.spi.exception.iceberg.AbstractIcebergCatalogException;

public class IcebergObjectDoesNotExistException
extends AbstractIcebergCatalogException {
    public static final String PROPERTY_ICEBERG_NAMESPACE_NAME = "iceberg-namespace-name";
    public static final String PROPERTY_ICEBERG_OBJECT_NAME = "iceberg-object-name";
    public static final String PROPERTY_ICEBERG_OBJECT_TYPE = "iceberg-object-type";

    public IcebergObjectDoesNotExistException(String namespaceName, String objectName) {
        this(namespaceName, objectName, Optional.empty());
    }

    public IcebergObjectDoesNotExistException(String namespaceName, String objectName, Optional<String> objectType) {
        super(CatalogErrorCode.ICEBERG_OBJECT_DOESNT_EXIST, String.format("Iceberg object \"%s.%s\" does not exist", namespaceName, objectName), IcebergObjectDoesNotExistException.toDetails(namespaceName, objectName, objectType));
    }

    public IcebergObjectDoesNotExistException(String message, Map<String, String> details) {
        super(CatalogErrorCode.ICEBERG_OBJECT_DOESNT_EXIST, message, details);
    }

    private static Map<String, String> toDetails(String namespaceName, String objectName, Optional<String> objectType) {
        if (objectType.isPresent()) {
            return Map.of(PROPERTY_ICEBERG_NAMESPACE_NAME, namespaceName, PROPERTY_ICEBERG_OBJECT_NAME, objectName, PROPERTY_ICEBERG_OBJECT_TYPE, objectType.get());
        }
        return Map.of(PROPERTY_ICEBERG_NAMESPACE_NAME, namespaceName, PROPERTY_ICEBERG_OBJECT_NAME, objectName);
    }

    public Optional<String> getObjectType() {
        return Optional.ofNullable(this.getDetails().get(PROPERTY_ICEBERG_OBJECT_TYPE));
    }
}

