/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception.iceberg;

import java.util.Map;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;
import ru.cedrusdata.catalog.spi.exception.CatalogException;

public class IcebergCatalogInUseException
extends CatalogException {
    public static final String PROPERTY_CATALOG_NAME = "iceberg-catalog-name";

    public IcebergCatalogInUseException(String catalogName) {
        super(CatalogErrorCode.ICEBERG_CATALOG_IN_USE, String.format("Iceberg catalog \"%s\" is used by other catalog objects", catalogName), Map.of(PROPERTY_CATALOG_NAME, catalogName));
    }

    public IcebergCatalogInUseException(String message, Map<String, String> details) {
        super(CatalogErrorCode.ICEBERG_CATALOG_IN_USE, message, details);
    }
}

