/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobCreateRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobInfo;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobUpdateRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationInfo;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationStartRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationStartResponse;

public class CatalogMaintenanceClient {
    private final InternalCatalogClient delegate;

    public CatalogMaintenanceClient(InternalCatalogClient delegate) {
        this.delegate = delegate;
    }

    public MaintenanceOperationStartResponse startOperation(MaintenanceOperationStartRequest request) {
        return this.delegate.startMaintenanceOperation(request);
    }

    public void cancelOperation(UUID operationId) {
        this.delegate.cancelMaintenanceOperation(operationId);
    }

    public MaintenanceOperationInfo getOperation(UUID operationId) {
        return this.delegate.getMaintenanceOperation(operationId);
    }

    public MaintenanceOperationListResponse listOperations(ResultPage page) {
        return this.listOperations(page, Optional.empty());
    }

    public MaintenanceOperationListResponse listOperations(ResultPage page, Optional<Map<String, Object>> filter) {
        return this.delegate.listMaintenanceOperations(page, filter);
    }

    public List<MaintenanceOperationInfo> listAllOperations() {
        MaintenanceOperationListResponse response;
        ArrayList<MaintenanceOperationInfo> res = new ArrayList<MaintenanceOperationInfo>();
        String nextPageToken = null;
        do {
            response = this.listOperations(new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }

    public void createJob(MaintenanceJobCreateRequest request) {
        this.delegate.createMaintenanceJob(request);
    }

    public void updateJob(String jobName, MaintenanceJobUpdateRequest request) {
        this.delegate.updateMaintenanceJob(jobName, request);
    }

    public void deleteJob(String jobName) {
        this.delegate.deleteMaintenanceJob(jobName);
    }

    public MaintenanceJobInfo getJob(String jobName) {
        return this.delegate.getMaintenanceJob(jobName);
    }

    public MaintenanceJobListResponse listJobs(ResultPage page) {
        return this.listJobs(page, Optional.empty());
    }

    public MaintenanceJobListResponse listJobs(ResultPage page, Optional<Map<String, Object>> filter) {
        return this.delegate.listMaintenanceJobs(page, filter);
    }

    public List<MaintenanceJobInfo> listAllJobs() {
        MaintenanceJobListResponse response;
        ArrayList<MaintenanceJobInfo> res = new ArrayList<MaintenanceJobInfo>();
        String nextPageToken = null;
        do {
            response = this.listJobs(new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }
}

