DROP TABLE metastore_table_group_table;
DROP TABLE metastore_table_group_namespace;
DROP TABLE metastore_table_group;

CREATE TABLE metastore_object_group(
    group_id UUID PRIMARY KEY,
    group_name VARCHAR NOT NULL UNIQUE,
    owner_id UUID NOT NULL,
    description VARCHAR,
    catalog_id UUID NOT NULL,
    FOREIGN KEY (owner_id) REFERENCES metastore_principal(principal_id),
    FOREIGN KEY (catalog_id) REFERENCES metastore_catalog(catalog_id) ON DELETE CASCADE
);

CREATE TABLE metastore_object_group_item(
    group_item_id UUID PRIMARY KEY,
    group_id UUID NOT NULL,
    namespace_id UUID,
    object_id UUID,
    FOREIGN KEY (group_id) REFERENCES metastore_object_group(group_id) ON DELETE CASCADE,
    FOREIGN KEY (namespace_id) REFERENCES metastore_iceberg_namespace(namespace_id) ON DELETE CASCADE,
    FOREIGN KEY (object_id) REFERENCES metastore_iceberg_table(table_id) ON DELETE CASCADE
);
