-- Predefined privilege type IDs. The mapping is hard-coded in Java.
-- Helps us mapping privilege names from user commands to stable IDs.
CREATE TABLE metastore_privilege_type(
    privilege_type_id UUID PRIMARY KEY,
    caption VARCHAR NOT NULL
);

INSERT INTO metastore_privilege_type VALUES ('dfa4ddd7-cc84-4257-811d-fc0631be6fc7', 'manage-grants');
INSERT INTO metastore_privilege_type VALUES ('e034a29a-f549-4033-9695-1a6041163793', 'management-read');

INSERT INTO metastore_privilege_type VALUES ('208f70bc-fe77-458a-8df8-32c479fa6eb9', 'principal.create');
INSERT INTO metastore_privilege_type VALUES ('d1a677db-08c0-40e7-b537-f27a6a98bc77', 'principal.usage');
INSERT INTO metastore_privilege_type VALUES ('c939b0e1-ea25-4d0b-9cab-43ea8f23d790', 'principal.alter');
INSERT INTO metastore_privilege_type VALUES ('ec8440de-fd1b-4d78-ad1e-2450ba3c8e84', 'principal.drop');
INSERT INTO metastore_privilege_type VALUES ('0d401df2-1f1c-4123-a1ed-59cd0945c7f9', 'principal.impersonate');
INSERT INTO metastore_privilege_type VALUES ('a1e4e3c5-d11c-44fc-836f-615f59543fa8', 'principal.manage-access-tokens');

INSERT INTO metastore_privilege_type VALUES ('22cdf370-73fb-4be6-86de-aa0e24cfc3dc', 'file-system.create');
INSERT INTO metastore_privilege_type VALUES ('1b50556b-4c8e-4fa6-9b7b-85a07b48bdbb', 'file-system.usage');
INSERT INTO metastore_privilege_type VALUES ('7e12a10f-cc79-4adf-8dea-44fa725ba479', 'file-system.alter');
INSERT INTO metastore_privilege_type VALUES ('a8300dc2-21c1-47de-9086-39a11b341a7c', 'file-system.drop');

INSERT INTO metastore_privilege_type VALUES ('684aad44-5961-437c-8145-0bf6401854b3', 'catalog.create');
INSERT INTO metastore_privilege_type VALUES ('55c36f3a-d2b4-4b42-9bf2-30de2b724630', 'catalog.usage');
INSERT INTO metastore_privilege_type VALUES ('21553838-5b19-481e-b8c3-089290f2b98a', 'catalog.alter');
INSERT INTO metastore_privilege_type VALUES ('4317509c-eeb7-4c11-9d23-6c44086a4de1', 'catalog.drop');

INSERT INTO metastore_privilege_type VALUES ('6f3cbb67-576f-45bb-8aca-dc94e83aa93d', 'namespace.create');
INSERT INTO metastore_privilege_type VALUES ('45c42b99-383d-4304-9f6b-c5580ff3fa39', 'namespace.usage');
INSERT INTO metastore_privilege_type VALUES ('d0291694-1756-4b62-b450-c60277334c21', 'namespace.alter');
INSERT INTO metastore_privilege_type VALUES ('cf3b404b-60de-44a6-a680-81722fbf273a', 'namespace.drop');

INSERT INTO metastore_privilege_type VALUES ('9879f63b-30d5-4c1b-875f-0154d1d8efd1', 'table.create');
INSERT INTO metastore_privilege_type VALUES ('3005ea71-e5f4-4fe6-8d0b-bf8b0e7c7548', 'table.usage');
INSERT INTO metastore_privilege_type VALUES ('d11df7d6-2667-477b-b697-b35011ec3169', 'table.alter');
INSERT INTO metastore_privilege_type VALUES ('917f1e0b-99ff-4a66-802b-9f1d799963bc', 'table.drop');
INSERT INTO metastore_privilege_type VALUES ('9b7873f3-e02d-419d-bca0-efaed1c715c7', 'table.modify');

INSERT INTO metastore_privilege_type VALUES ('40475128-992c-4356-9fb2-09b40e0dc203', 'view.create');
INSERT INTO metastore_privilege_type VALUES ('09698225-e978-4b0e-b921-b9250103de0c', 'view.usage');
INSERT INTO metastore_privilege_type VALUES ('dc751164-605f-4000-b8d3-f6813f0f5b87', 'view.alter');
INSERT INTO metastore_privilege_type VALUES ('472ca0f0-8b1d-465d-8d71-497f232d7a47', 'view.drop');

INSERT INTO metastore_privilege_type VALUES ('ce9f0032-2e62-47b6-aa00-21b0f84d3aa0', 'materialized-view.create');
INSERT INTO metastore_privilege_type VALUES ('caf7a5a6-0b5c-4afa-b6a2-10a14b050839', 'materialized-view.usage');
INSERT INTO metastore_privilege_type VALUES ('1504aad7-bbdc-4e6e-8b61-87b05e647281', 'materialized-view.alter');
INSERT INTO metastore_privilege_type VALUES ('c2551fc6-b0eb-4cd9-bb69-dffb2eed158d', 'materialized-view.drop');
INSERT INTO metastore_privilege_type VALUES ('55fe62da-ff22-4707-86d9-302652167626', 'materialized-view.modify');

INSERT INTO metastore_privilege_type VALUES ('a778072d-b08a-4170-82eb-200eac18a3eb', 'object-group.create');
INSERT INTO metastore_privilege_type VALUES ('7e690e1e-d11d-4b8b-b241-072bdb74bdd3', 'object-group.usage');
INSERT INTO metastore_privilege_type VALUES ('940abff8-fac5-41ee-9bc0-415857a47f69', 'object-group.alter');
INSERT INTO metastore_privilege_type VALUES ('0f0a76c9-a902-49d7-98e0-cc3c199451f0', 'object-group.drop');

INSERT INTO metastore_privilege_type VALUES ('38b7b73b-0e6f-4d65-b48a-e67a390f14e1', 'compute-engine.create');
INSERT INTO metastore_privilege_type VALUES ('66dd9963-3a36-4e39-a2be-3b4991d9b3fc', 'compute-engine.usage');
INSERT INTO metastore_privilege_type VALUES ('6129abf0-31df-4a98-8fde-de5dad01629d', 'compute-engine.alter');
INSERT INTO metastore_privilege_type VALUES ('e9de7236-f38b-45be-a254-607ff0a3f5a0', 'compute-engine.drop');

INSERT INTO metastore_privilege_type VALUES ('587b9995-79d7-4e54-8bad-4b56471c8cf4', 'job.create');
INSERT INTO metastore_privilege_type VALUES ('76199ed7-30a6-4eda-82e7-8ab01ab74b88', 'job.usage');
INSERT INTO metastore_privilege_type VALUES ('d77a3d45-6246-4837-8e61-a6f3ad22dd73', 'job.alter');
INSERT INTO metastore_privilege_type VALUES ('c30d3d76-42e1-4c1c-aa4b-ac8629768af2', 'job.drop');

CREATE TABLE metastore_privilege(
    principal_id UUID NOT NULL,
    privilege_type_id UUID NOT NULL,
    securable_id UUID NOT NULL,
    owner_id UUID NOT NULL,
    securable_principal_id UUID,
    securable_file_system_id UUID,
    securable_catalog_id UUID,
    securable_namespace_id UUID,
    securable_object_id UUID,
    securable_object_group_id UUID,
    securable_compute_engine_id UUID,
    securable_job_id UUID,
    PRIMARY KEY (principal_id, privilege_type_id, securable_id),
    FOREIGN KEY (principal_id) REFERENCES metastore_principal(principal_id) ON DELETE CASCADE,
    FOREIGN KEY (privilege_type_id) REFERENCES metastore_privilege_type(privilege_type_id),
    FOREIGN KEY (owner_id) REFERENCES metastore_principal(principal_id),
    FOREIGN KEY (securable_principal_id) REFERENCES metastore_principal(principal_id) ON DELETE CASCADE,
    FOREIGN KEY (securable_file_system_id) REFERENCES metastore_file_system(file_system_id) ON DELETE CASCADE,
    FOREIGN KEY (securable_catalog_id) REFERENCES metastore_catalog(catalog_id) ON DELETE CASCADE,
    FOREIGN KEY (securable_namespace_id) REFERENCES metastore_iceberg_namespace(namespace_id) ON DELETE CASCADE,
    FOREIGN KEY (securable_object_id) REFERENCES metastore_iceberg_table(table_id) ON DELETE CASCADE,
    FOREIGN KEY (securable_object_group_id) REFERENCES metastore_object_group(group_id) ON DELETE CASCADE,
    FOREIGN KEY (securable_compute_engine_id) REFERENCES metastore_compute_engine(engine_id) ON DELETE CASCADE,
    FOREIGN KEY (securable_job_id) REFERENCES metastore_maintenance_job(job_id) ON DELETE CASCADE
);

-- Add builtin.iceberg.admin privileges.
-- Metastore ID: 1345585d-2cf4-4f9b-9e0a-b09ce9f79e35
INSERT INTO metastore_privilege(principal_id, privilege_type_id, securable_id, owner_id)
WITH iceberg_admin_role AS (SELECT principal_id FROM metastore_principal WHERE principal_name = 'builtin.iceberg.admin')
SELECT
     (SELECT principal_id FROM iceberg_admin_role),
     privilege_type_id,
     '1345585d-2cf4-4f9b-9e0a-b09ce9f79e35',
     (SELECT principal_id FROM iceberg_admin_role)
FROM metastore_privilege_type WHERE caption IN (
    -- Ability to impersonate other users to ensure that we can run impersonated mode in long-running processes (e.g., CedrusData)
    'principal.impersonate',
    -- Ability to inspect file systems
    'file-system.usage',
    -- Ability to manage catalogs
    'catalog.create',
    'catalog.alter',
    'catalog.drop',
    -- Ability to manage namespaces
    'namespace.create',
    'namespace.alter',
    'namespace.drop',
    -- Ability to manage namespace objects,
    'table.create',
    'table.alter',
    'table.drop',
    'table.modify',
    'view.create',
    'view.alter',
    'view.drop',
    'materialized-view.create',
    'materialized-view.alter',
    'materialized-view.drop',
    'materialized-view.modify',
    --Ability to manage object groups for maintenance
    'object-group.create',
    'object-group.alter',
    'object-group.drop',
    -- Ability to execute maintenance operations
    'compute-engine.usage',
    -- Ability to schedule maintenance jobs
    'job.create',
    'job.alter',
    'job.drop');
