/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.common.http.authenticator;

import io.prometheus.jmx.common.http.authenticator.Credentials;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class CredentialsCache {
    private final int maximumCacheSizeBytes;
    private final LinkedHashMap<Credentials, Byte> linkedHashMap;
    private final LinkedList<Credentials> linkedList;
    private int currentCacheSizeBytes;

    public CredentialsCache(int maximumCacheSizeBytes) {
        this.maximumCacheSizeBytes = maximumCacheSizeBytes;
        this.linkedHashMap = new LinkedHashMap();
        this.linkedList = new LinkedList();
    }

    public synchronized void add(Credentials credentials) {
        int credentialSizeBytes = credentials.toString().getBytes(StandardCharsets.UTF_8).length;
        if (credentialSizeBytes > this.maximumCacheSizeBytes) {
            return;
        }
        while (this.currentCacheSizeBytes + credentialSizeBytes > this.maximumCacheSizeBytes && this.currentCacheSizeBytes > 0) {
            Credentials c = this.linkedList.removeLast();
            this.linkedHashMap.remove(c);
            this.currentCacheSizeBytes -= credentialSizeBytes;
            if (this.currentCacheSizeBytes >= 0) continue;
            this.currentCacheSizeBytes = 0;
        }
        this.linkedHashMap.put(credentials, (byte)1);
        this.linkedList.addFirst(credentials);
        this.currentCacheSizeBytes += credentialSizeBytes;
    }

    public synchronized boolean contains(Credentials credentials) {
        return this.linkedHashMap.containsKey(credentials);
    }

    public synchronized boolean remove(Credentials credentials) {
        if (this.linkedHashMap.remove(credentials) != null) {
            this.linkedList.remove(credentials);
            this.currentCacheSizeBytes -= credentials.toString().getBytes(StandardCharsets.UTF_8).length;
            return true;
        }
        return false;
    }

    public int getMaximumCacheSizeBytes() {
        return this.maximumCacheSizeBytes;
    }

    public synchronized int getCurrentCacheSizeBytes() {
        return this.currentCacheSizeBytes;
    }
}

